local include = ...

local modname = minetest.get_current_modname()

local api = rawget(_G, modname) or {}
rawset(_G, modname, api)

local exportdb, savedb = include("exportdb")
local exportall = include("exportall")

function api.get_all()
	local t = {}
	for k in pairs(exportdb) do t[k] = true end
	return t
end

function api.get(k) return exportdb[k] end

function api.set(k, v)
	exportdb[k] = v and true or nil
end

function api.export()
	savedb()
	return exportall()
end