-- LUALOCALS < ---------------------------------------------------------
local io, minetest
    = io, minetest
local io_open
    = io.open
-- LUALOCALS > ---------------------------------------------------------

local include = ...
local getdir = include("fileops")

local modname = minetest.get_current_modname()
local dbpath = getdir(minetest.get_worldpath()
	.. "/" .. modname) .. "/export.json"

local exportdb
do
	local fh = io_open(dbpath, "r")
	if fh then
		local s = fh:read("*all")
		fh:close()
		exportdb = s and minetest.parse_json(s) or {}
	else
		local modstore = minetest.get_mod_storage()
		local s = modstore:get_string("export")
		exportdb = s and s ~= "" and minetest.deserialize(s) or {}
	end
end

local blocked = {
	air = true,
	ignore = true
}

local function savedb()
	for k in pairs(blocked) do exportdb[k] = nil end
	minetest.safe_file_write(dbpath, minetest.write_json(exportdb, true))
end

return exportdb, savedb
