-- LUALOCALS < ---------------------------------------------------------
local minetest, rawget, rawset
    = minetest, rawget, rawset
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

local api = rawget(_G, modname) or {}
rawset(_G, modname, api)

-- Check if a node is willing to be a source of support in
-- a specific direction. "From" is the position from which
-- the request for support is coming (i.e. the position TO
-- which support would be provided)

-- node parameter is optional; if provided, it's trusted.

function api.source_check(pos, node, from)
	node = node or minetest.get_node(pos)
	local def = minetest.registered_nodes[node.name]
	local src = def and def.fdm_source
	return src and src(pos, node, from)
end
