-- LUALOCALS < ---------------------------------------------------------
local ipairs, minetest, pairs, vector
    = ipairs, minetest, pairs, vector
-- LUALOCALS > ---------------------------------------------------------

local hudrange = 80

local modname = minetest.get_current_modname()
local hash = minetest.hash_node_position

local found = {}

local function addfound(pos) found[hash(pos)] = pos end

minetest.register_lbm({
		name = modname .. ":detect",
		run_at_every_load = true,
		nodenames = {"group:" .. modname .. "_bad"},
		action = addfound
	})
minetest.register_abm({
		nodenames = {"group:" .. modname .. "_bad"},
		interval = 1,
		chance = 1,
		action = addfound
	})

local huds = {}
minetest.register_on_leaveplayer(function(player) huds[player:get_player_name()] = nil end)

local function checkplayer(player)
	local pname = player:get_player_name()

	local ppos = player:get_pos()
	ppos.y = ppos.y + player:get_properties().eye_height

	local phuds = huds[pname] or {}
	local newhuds = {}
	for k, v in pairs(found) do
		if vector.distance(ppos, v) <= hudrange then
			local old = phuds[k]
			if old then
				newhuds[k] = old
			else
				newhuds[k] = player:hud_add({
						hud_elem_type = "image_waypoint",
						world_pos = v,
						text = "fdm_material_basic.png^[invert:rgb"
						.. "^[resize:32x32^[mask:fdm_validate_hud.png",
						scale = {x = 1, y = 1}
					})
			end
		end
	end
	for k, v in pairs(phuds) do
		if not newhuds[k] then
			player:hud_remove(v)
		end
	end

	huds[pname] = newhuds
end

local okaynodes = {}
minetest.after(0, function()
		for k, v in pairs(minetest.registered_nodes) do
			if v.groups and v.groups[modname .. "_bad"] then
				okaynodes[k] = true
			end
		end
	end)

local function timer()
	local filtered = {}
	for k, v in pairs(found) do
		local n = minetest.get_node(v)
		if okaynodes[n.name] then
			filtered[k] = v
		end
	end
	found = filtered
	for _, player in ipairs(minetest.get_connected_players()) do
		checkplayer(player)
	end
	minetest.after(1, timer)
end
minetest.after(0, timer)

minetest.register_on_joinplayer(function(player)
		player:hud_add({
				hud_elem_type = "image_waypoint",
				world_pos = vector.new(0, 9.5, 0),
				text = "fdm_nav_origin.png^[opacity:128",
				scale = {x = 1, y = 1}
			})
	end)
