-- LUALOCALS < ---------------------------------------------------------
local fdm_api, minetest, vector
    = fdm_api, minetest, vector
-- LUALOCALS > ---------------------------------------------------------

local bedname = "fdm_material:bed"

local function addneighbors(pos, queue)
	for dx = -1, 1 do
		for dy = -1, 1 do
			for dz = -1, 1 do
				queue[#queue + 1] = vector.add(pos, vector.new(dx, dy, dz))
			end
		end
	end
end

local function bedheal(pos, node, queue)
	if pos.y > 8 then return end
	node = node or minetest.get_node(pos)
	if node.name == bedname then return end
	node.name = bedname
	minetest.set_node(pos, node)
	if queue then return addneighbors(pos, queue) end
	queue = {}
	addneighbors(pos, queue)
	local stop = minetest.get_us_time() + 1000000
	while #queue > 0 and minetest.get_us_time() < stop do
		local batch = queue
		queue = {}
		for i = 1, #batch do
			bedheal(batch[i], nil, queue)
		end
	end
end

fdm_api.register_on_nodeupdate(bedheal)
