-- LUALOCALS < ---------------------------------------------------------
local ipairs, minetest, pairs
    = ipairs, minetest, pairs
-- LUALOCALS > ---------------------------------------------------------

-- Find the set of items to initialize the player's inventory
-- with, and memoize the result so we don't have to scan each time.
local function memoitems()
	local items = {}
	for k, v in pairs(minetest.registered_items) do
		if v.fdm_inv_slot then
			items[v.fdm_inv_slot] = k
		end
	end
	local max = 0
	for i in pairs(items) do
		if i > max then max = i end
	end
	memoitems = function() return items, max end
	return items, max
end

-- Fix hotbar/wielditem visibility if it doesn't match player's privileges
local hotbars = {}
minetest.register_on_leaveplayer(function(player)
		hotbars[player:get_player_name()] = nil
	end)
local function checkhotbar(player)
	local pname = player:get_player_name()
	local interact = minetest.check_player_privs(pname, "interact") and true or false
	local old = hotbars[pname]
	if interact == old then return end
	player:hud_set_flags({
			wielditem = interact,
			hotbar = interact,
		})
	hotbars[pname] = interact
end

minetest.register_on_joinplayer(function(player)
		-- Initialize inventory contents
		local items, max = memoitems()
		local inv = player:get_inventory()
		for k in pairs(inv:get_lists()) do
			inv:set_size(k, k == "main" and max or 0)
		end
		for i = 1, max do
			if items[i] then inv:set_stack("main", i, items[i]) end
		end
		player:hud_set_hotbar_itemcount(max)

		-- Initialize hotbar image
		player:hud_set_hotbar_image("[combine:16x16")
		player:hud_set_hotbar_selected_image("fdm_player_select.png")

		-- Check hotbar visibility immediately on join
		checkhotbar(player)

		-- Disable inventory screen
		player:set_inventory_formspec("")
	end)

-- Players may not alter inventory
minetest.register_allow_player_inventory_action(function() return 0 end)

-- Keep hotbar visibility in sync with privileges
minetest.register_globalstep(function()
		for _, player in ipairs(minetest.get_connected_players()) do
			checkhotbar(player)
		end
	end)
