-- LUALOCALS < ---------------------------------------------------------
local klots, minetest, pairs, vector
    = klots, minetest, pairs, vector
-- LUALOCALS > ---------------------------------------------------------

local terraindef = {
	stack_max = 1,
	on_use = function(_, _, pointed)
		if pointed and pointed.under then
			minetest.remove_node(pointed.under)
		end
	end,
	on_secondary_use = function(stack, user)
		if not user then return end
		local pos = user:get_pos()
		pos.y = pos.y + user:get_properties().eye_height
		pos = vector.add(pos, vector.multiply(user:get_look_dir(), 4))
		minetest.item_place(stack, user, {
				type = "node",
				above = pos,
				under = pos
			})
		-- return nil -> no consumption
	end,
	on_place = function(stack, user, pointed)
		minetest.item_place(stack, user, pointed)
		-- return nil -> no consumption
	end
}

function klots.register_terrain(def)
	local name = def.name
	for k, v in pairs(terraindef) do
		if def[k] == nil then
			def[k] = v
		end

	end
	if def.pointable == nil then
		def.pointable = klots.editmode or def.walkable or def.walkable == nil or false
	end
	minetest.register_node(minetest.get_current_modname() .. ":" .. name, def)
end
