-- LUALOCALS < ---------------------------------------------------------
local klots, minetest, vector
    = klots, minetest, vector
-- LUALOCALS > ---------------------------------------------------------

local radius = 32
radius = {x = radius, y = radius, z = radius}

minetest.register_chatcommand("reset", {
		description = "Reset the current level",
		func = function(name)
			if not minetest.is_singleplayer() then
				return false, "this command is for singleplayer only"
			end

			local player = minetest.get_player_by_name(name)
			if not player then return false, "invalid player" end

			local tpto = player:get_meta():get_string("last_teleport")
			tpto = tpto and tpto ~= "" and minetest.deserialize(tpto)
			or {x = 0, y = 9, z = 0}

			local pos = player:get_pos()
			klots.player_control_set(player, "frozen")
			klots.flash_screen(player, "#000000", true)
			minetest.after(0, function()
					minetest.after(0, function()
							minetest.delete_area(vector.subtract(pos, radius),
								vector.add(pos, radius))
							klots.player_teleport(player, pos, tpto)
						end)
				end)
		end
	})

minetest.registered_chatcommands.kill = minetest.registered_chatcommands.reset
