# Klots

Sliding block puzzles with a modern twist.

Solve the mystery of the alien crash site.

## Instructions

...should not be necessary.  The game has very simple controls.  Explore and learn the mechanics as you go.

## Editing and Level Design

To edit the map, create a special "editing" world:

- Create a new klots world.
- Add a file named `klots_edit` in the root of the world dir.
- Install the [modgen](/packages/BuckarooBanzay/modgen/) mod.
- Enter the editing world and grant yourself the necessary permissions.
- Teleport/fly to each existing level and use `/export` or `/export_here` to register the area with modgen and export it.
	- You can use `/autosave on` to enable autosaving for future edits in registered areas.
	- Right-clicking a teleporter node with a non-empty hand will allow you to view/edit the destination.
	- Registering and exporting the existing map areas is necessary to include them in the manifest.

Editing mode:

- Right-click a node with an empty hand to pick up a copy of the node.
- To free up inventory space, you can simply drop items; they are destroyed.  Use `/clearinv` to do the whole thing.
- There is no "creative mode" menu (yet).  Use [szutil_givemenu](/packages/Warr1024/szutilpack/) to add the `/gm` command with a more convenient search interface.
- If you right-click to place a node without pointing at another node, it will place that node at the extent of your reach (4 nodes away) in mid-air; use this to start mid-air structures.

Install map updates into the game:

- Exit the editing world after all exports have quiesced.
- From the `modgen_mod_export` dir inside the world dir, copy the `manifest.json` file and `map` dir and all its contents over the corresponding items in `mods/klots_mapgen` within the game dir.
- To play test, create a new world *without* the klots_edit file.

Submitting levels for official inclusion:

- [worldedit](/packages/sfan5/worldedit/) format is preferred.
	- For replacements for existing levels, please provide the exact coordinates at which it should be imported.
- Levels must fit somewhere in the progression, i.e. use existing skills learned in previous levels, and add some new challenge/insight.
- Levels must also fit the general theme and atmosphere of the game, and if possible should try to build on the narrative via environmental storytelling.
- Updates/improvements/fixes for existing levels are also welcome.

## Credits

- klots_player
	- klots_player_model.b3d
		- LoneWolfHT and MisterE (MIT)
		- From NodeCore
	- klots_player_hand.obj
		- LoneWolfHT (MIT)
		- From NodeCore
	- klots_player_skin.png
		- WintersKnight94 (MIT)
		- From NodeCore, heavily modified
- klots_skybox
	- space skybox textures
		- Westbeam (CC0 / WTFPL)
		- https://opengameart.org/content/space-skyboxes-1
	- land skybox textures
		- Emil Persson (CC-BY 3.0)
		- https://opengameart.org/content/mountain-skyboxes
- klots_terrain_mtg
	- all textures by various artists:
		- BlockMen (CC BY-SA 3.0)
		- Cisoun (CC-BY-SA 3.0)
		- Extex101 (CC BY-SA 3.0)
		- Gambit (CC BY-SA 3.0)
		- Krock (CC0 1.0)
		- MasterGollum (CC BY 3.0)
		- Mossmanikin (CC BY-SA 3.0)
		- Muadtralk (CC BY-SA 3.0)
		- Neuromancer (CC BY-SA 3.0)
		- npx (CC BY-SA 3.0)
		- paramat (CC BY-SA 3.0)
		- PilzAdam (CC BY-SA 3.0)
		- random-geek (CC BY-SA 3.0)
		- RealBadAngel (CC-BY-SA 3.0)
		- RHRhino (CC BY-SA 3.0)
		- yyt16384 (CC BY-SA 3.0)
		- Shara RedCat (CC BY-SA 3.0)
		- sofar (CC BY-SA 3.0)
		- Splizard (CC BY-SA 3.0)
		- tobyplowy (CC BY-SA 3.0)
		- TumeniNodes (CC-BY-SA 3.0)
		- xyz (CC BY-SA 3.0)
		- From minetest_game
			- default
			- farming
			- fire
			- flowers
			- xpanes
	- all sounds by various artists:
		- AGFX (CC BY 3.0)
		- Erdie (CC BY 3.0)
		- Iwan Gabovitch - qubodup (CC0)
		- Mito551 (CC BY-SA 3.0)
		- Ogrebane (CC0 1.0)
		- Sheyvan (CC0 1.0)
		- worthahep88 (CC0 1.0)
		- yadronoff (CC-BY 3.0)
		- From minetest_game default
- klots_terrain_scifi
	- all scifi_* textures and nodebox designs
		- DOOMED (CC-BY-SA 3.0 UNPORTED)
		- From scifi_nodes mod
- klots_mapgen
	- modgen_*.lua
		- BuckarooBanzay (MIT)
		- From the modgen export mod