-- LUALOCALS < ---------------------------------------------------------
local klots
    = klots
-- LUALOCALS > ---------------------------------------------------------

klots.register_terrain({
		tiles = {
			{
				name = "scifi_nodes_liquid.png",
				animation = {
					type = "vertical_frames",
					length = 1,
					aspect_h = 16,
					aspect_w = 16
				}
			}
		},
		light_source = 14,
		drawtype = "nodebox",
		sunlight_propagates = true,
		name = "liquid_pipe",
		use_texture_alpha = "blend",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.375,
					-0.5,
					-0.375,
					0.375,
					0.5,
					0.375
				}
			}
		},
		paramtype = "light",
		description = "Liquid pipe"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_lighttop.png",
			"scifi_nodes_lighttop.png",
			"scifi_nodes_light.png",
			"scifi_nodes_light.png",
			"scifi_nodes_light.png",
			"scifi_nodes_light.png"
		},
		light_source = 10,
		name = "light",
		sunlight_propagates = false,
		paramtype = "light",
		description = "blue lightbox"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_blackdmg.png"
		},
		name = "blackdmg",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Damaged black wall"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_bluemetal.png"
		},
		name = "bluemetal",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "blue metal"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_blackpipe.png"
		},
		name = "blackpipe",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "black pipe"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_white2.png",
			"scifi_nodes_white2.png",
			"scifi_nodes_white2.png",
			"scifi_nodes_white2.png",
			"scifi_nodes_white2.png",
			"scifi_nodes_white_pad.png"
		},
		name = "white_pad",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = false,
		paramtype = "light",
		description = "white keypad"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_lighttop.png",
			"scifi_nodes_lighttop.png",
			"scifi_nodes_greenlight.png",
			"scifi_nodes_greenlight.png",
			"scifi_nodes_greenlight.png",
			"scifi_nodes_greenlight.png"
		},
		light_source = 10,
		name = "green_light",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		sunlight_propagates = false,
		paramtype = "light",
		description = "green lightbox"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_glass.png"
		},
		name = "glass",
		use_texture_alpha = "blend",
		sunlight_propagates = true,
		paramtype = "light",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		drawtype = "glasslike",
		description = "dark glass"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_pad.png",
			"scifi_nodes_pad.png",
			"scifi_nodes_pad.png",
			"scifi_nodes_pad.png",
			"scifi_nodes_pad.png",
			"scifi_nodes_pad.png"
		},
		light_source = 5,
		name = "pad",
		node_box = {
			type = "fixed",
			sounds = {
				dug = {
					name = "default_wood_footstep",
					gain = 1
				},
				dig = {
					name = "default_dig_choppy",
					gain = 0.4
				},
				footstep = {
					name = "default_wood_footstep",
					gain = 0.15
				},
				place = {
					name = "default_place_node_hard",
					gain = 1
				}
			},
			fixed = {
				{
					-0.9375,
					-0.5,
					-0.75,
					0.875,
					-0.375,
					0.75
				},
				{
					-0.8125,
					-0.5,
					-0.875,
					0.75,
					-0.375,
					0.875
				},
				{
					-0.875,
					-0.5,
					-0.8125,
					0.8125,
					-0.375,
					0.8125
				},
				{
					-0.8125,
					-0.5,
					-0.75,
					0.75,
					-0.3125,
					0.75
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox",
		description = "teleport pad"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_doomwall41.png"
		},
		name = "doomwall41",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Doom wall 4.1"
	})

klots.register_terrain({
		node_box = {
			type = "wallmounted"
		},
		light_source = 5,
		drawtype = "signlike",
		sunlight_propagates = true,
		name = "protected_switch_on",
		tiles = {
			"scifi_nodes_switch_on.png"
		},
		paramtype2 = "wallmounted",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Protected wall switch"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_rock.png"
		},
		light_source = 0,
		name = "rock",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Moonstone"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_greentubes.png"
		},
		name = "greentubes",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "green pipes"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_dent.png"
		},
		name = "dent",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "dented metal block"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_greybolts.png"
		},
		name = "greybolts",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "grey wall bolts"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octbl.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "octbl_pane_offset",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					0.96875,
					0.5,
					0.5,
					1.03125
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Blue Octagon Glass pane"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octppl.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "octppl_pane_offset",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					0.96875,
					0.5,
					0.5,
					1.03125
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Purple Octagon Glass pane"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_greenpipe_front.png",
			"scifi_nodes_greenpipe_front.png",
			"scifi_nodes_greenpipe_top.png",
			"scifi_nodes_greenpipe_top.png",
			"scifi_nodes_greenpipe_top.png",
			"scifi_nodes_greenpipe_top.png"
		},
		name = "grnpipe",
		sunlight_propagates = false,
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_dug_metal",
				gain = 0.5
			},
			dig = {
				name = "default_dig_metal",
				gain = 0.5
			},
			footstep = {
				name = "default_metal_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_metal",
				gain = 0.5
			}
		},
		paramtype = "light",
		description = "green pipe"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_doomengine.png"
		},
		name = "doomengine",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Doom engine wall"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_egg_top.png",
			"scifi_nodes_egg_top.png",
			"scifi_nodes_egg_side.png",
			"scifi_nodes_egg_side.png",
			"scifi_nodes_egg_side.png",
			"scifi_nodes_egg_side.png"
		},
		name = "egg",
		light_source = 5,
		sunlight_propagates = false,
		paramtype = "light",
		node_box = {
			type = "fixed",
			sounds = {
				dug = {
					name = "default_wood_footstep",
					gain = 1
				},
				dig = {
					name = "default_dig_choppy",
					gain = 0.4
				},
				footstep = {
					name = "default_wood_footstep",
					gain = 0.15
				},
				place = {
					name = "default_place_node_hard",
					gain = 1
				}
			},
			fixed = {
				{
					-0.25,
					-0.5,
					-0.25,
					0.25,
					-0.4375,
					0.25
				},
				{
					-0.375,
					-0.4375,
					-0.375,
					0.375,
					-0.3125,
					0.375
				},
				{
					-0.4375,
					-0.3125,
					-0.375,
					0.4375,
					0.3125,
					0.375
				},
				{
					-0.375,
					0.3125,
					-0.375,
					0.375,
					0.4375,
					0.375
				},
				{
					-0.3125,
					0.4375,
					-0.3125,
					0.3125,
					0.5625,
					0.3125
				},
				{
					-0.25,
					0.5625,
					-0.25,
					0.25,
					0.6875,
					0.25
				},
				{
					-0.1875,
					0.6875,
					-0.1875,
					0.1875,
					0.75,
					0.1875
				},
				{
					-0.125,
					0.75,
					-0.125,
					0.125,
					0.8125,
					0.125
				},
				{
					-0.375,
					-0.3125,
					-0.4375,
					0.375,
					0.3125,
					0.4375
				}
			}
		},
		drawtype = "nodebox",
		description = "Alien Egg"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_ultra_white.png"
		},
		light_source = 14,
		name = "ultra_white",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Ultra Plastic"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octppl.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "octppl_pane_double",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.03125,
					0.5,
					1.5,
					0.03125
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Purple Octagon Glass pane"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_pwrstnd_top.png",
			"scifi_nodes_pwrstnd_top.png",
			"scifi_nodes_pwrstnd_top.png",
			"scifi_nodes_pwrstnd_top.png",
			"scifi_nodes_pwrstnd_top.png",
			"scifi_nodes_pwrstnd_top.png"
		},
		name = "cover",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.375,
					-0.5,
					-0.3125,
					0.375,
					-0.375,
					0.3125
				},
				{
					-0.3125,
					-0.5,
					-0.375,
					0.3125,
					-0.375,
					0.375
				},
				{
					-0.3125,
					-0.375,
					-0.3125,
					0.3125,
					-0.3125,
					0.3125
				}
			}
		},
		paramtype = "light",
		sounds = {
			dug = {
				name = "default_wood_footstep",
				gain = 1
			},
			dig = {
				name = "default_dig_choppy",
				gain = 0.4
			},
			footstep = {
				name = "default_wood_footstep",
				gain = 0.15
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		drawtype = "nodebox",
		description = "Metal cover"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png"
		},
		name = "laptop_closed",
		sunlight_propagates = true,
		paramtype = "light",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.4375,
					-0.5,
					-0.4375,
					0.4375,
					-0.25,
					0.3125
				}
			}
		},
		drawtype = "nodebox",
		description = "laptop"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_discs.png",
			"scifi_nodes_discs.png",
			"scifi_nodes_discs.png",
			"scifi_nodes_discs.png"
		},
		name = "discs",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		sunlight_propagates = false,
		paramtype = "light",
		description = "disc shelves"
	})

klots.register_terrain({
		node_box = {
			type = "wallmounted"
		},
		light_source = 5,
		drawtype = "signlike",
		sunlight_propagates = true,
		name = "switch_on",
		tiles = {
			"scifi_nodes_switch_on.png"
		},
		paramtype2 = "wallmounted",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Wall switch"
	})

klots.register_terrain({
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					0.5,
					0.5,
					0.0625
				}
			}
		},
		name = "Doom_door_closed",
		tiles = {
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_rbottom.png",
			"scifi_nodes_door_Doom_bottom.png"
		},
		paramtype2 = "facedir",
		drawtype = "nodebox",
		paramtype = "light",
		description = "Doom sliding door"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_glass.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "glass_pane",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.03125,
					0.5,
					0.5,
					0.03125
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Dark Glass pane"
	})

klots.register_terrain({
		sunlight_propagates = false,
		name = "disc",
		paramtype = "light",
		tiles = {
			"scifi_nodes_disc.png"
		},
		drawtype = "torchlike",
		description = "disc"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_lightband.png"
		},
		light_source = 10,
		name = "whtlightbnd",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		sunlight_propagates = false,
		paramtype = "light",
		description = "white light stripe"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_lightoverlay.png"
		},
		light_source = 14,
		drawtype = "signlike",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "light_dynamic",
		paramtype2 = "wallmounted",
		node_box = {
			type = "fixed",
			fixed = {
				fixed = {
					-0.5,
					-0.5,
					-0.5,
					-0.45,
					0.5,
					0.5
				}
			}
		},
		paramtype = "light",
		description = "Wall light"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_greenbar.png"
		},
		light_source = 10,
		name = "greenbar",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "green light bar"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_blue_square.png"
		},
		name = "blue_square",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "blue metal block"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_bluemetal.png",
			"scifi_nodes_bluemetal.png",
			"scifi_nodes_blue_metal_light.png",
			"scifi_nodes_blue_metal_light.png",
			"scifi_nodes_blue_metal_light.png",
			"scifi_nodes_blue_metal_light.png"
		},
		light_source = 10,
		name = "blumetlight",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		sunlight_propagates = false,
		paramtype = "light",
		description = "blue metal light"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_rbottom0.png",
			"scifi_nodes_door_white_bottom0.png"
		},
		name = "white_door_opened",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					-0.25,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox"
	})

klots.register_terrain({
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					0.5,
					0.5,
					0.0625
				}
			}
		},
		name = "blue_door_closed",
		tiles = {
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_rbottom.png",
			"scifi_nodes_door_blue_bottom.png"
		},
		paramtype2 = "facedir",
		drawtype = "nodebox",
		paramtype = "light",
		description = "blue sliding door"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_pipeside.png"
		},
		name = "pipeside",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "side pipe"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_keyboard.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_monitor.png"
		},
		name = "keysmonitor",
		sunlight_propagates = true,
		paramtype = "light",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.4375,
					0.5,
					-0.4375,
					-0.0625
				},
				{
					-0.125,
					-0.5,
					0.375,
					0.125,
					0.0625,
					0.4375
				},
				{
					-0.25,
					-0.5,
					0.125,
					0.25,
					-0.4375,
					0.5
				},
				{
					-0.5,
					-0.3125,
					0.25,
					0.5,
					0.5,
					0.375
				}
			}
		},
		drawtype = "nodebox",
		description = "Keyboard and monitor"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_black_mesh.png"
		},
		name = "black_mesh",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "black vent block"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_grass.png"
		},
		visual_scale = 1,
		light_source = 0,
		name = "grass",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Alien Grass"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_doomwall3.png"
		},
		name = "doomwall3",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Doom wall 3"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_blue_metal_stripes2.png"
		},
		light_source = 10,
		name = "blumetstr",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		sunlight_propagates = false,
		paramtype = "light",
		description = "blue stripe light"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_doomwall42.png"
		},
		name = "doomwall42",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Doom wall 4.2"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_blue.png"
		},
		name = "blue",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "blue lines"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_greenlights2.png"
		},
		light_source = 10,
		name = "greenlights2",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "green wall lights2"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_plant10.png"
		},
		visual_scale = 1,
		light_source = 10,
		name = "plant10",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Umbrella weed"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_plant2.png"
		},
		visual_scale = 1.5,
		light_source = 14,
		name = "plant2",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Trap Plant"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_black_light2.png"
		},
		light_source = 10,
		name = "blklt2",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		sunlight_propagates = false,
		paramtype = "light",
		description = "black stripe light"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_plant9.png"
		},
		visual_scale = 1,
		light_source = 0,
		name = "plant9",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Prickly Plant"
	})

klots.register_terrain({
		tiles = {
			{
				name = "scifi_nodes_screen.png",
				animation = {
					type = "vertical_frames",
					length = 0.5,
					aspect_h = 16,
					aspect_w = 16
				}
			}
		},
		light_source = 5,
		name = "screen",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		sunlight_propagates = false,
		paramtype = "light",
		description = "electronic screen"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_purple.png"
		},
		light_source = 0,
		name = "purple",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Purple node"
	})

klots.register_terrain({
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					0.5,
					0.5,
					0.0625
				}
			}
		},
		name = "white_door_closed",
		tiles = {
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_rbottom.png",
			"scifi_nodes_door_white_bottom.png"
		},
		paramtype2 = "facedir",
		drawtype = "nodebox",
		paramtype = "light",
		description = "white sliding door"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_lightstripe.png"
		},
		light_source = 14,
		name = "lightstp",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		sunlight_propagates = false,
		paramtype = "light",
		description = "twin lights"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_red.png"
		},
		name = "red",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "red lines"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_purple.png",
			"scifi_nodes_purple.png",
			"scifi_nodes_purple.png",
			"scifi_nodes_purple.png",
			"scifi_nodes_pplwndw.png",
			"scifi_nodes_pplwndw.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "pplwndw",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					0.5,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		description = "Purple Window"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_rust.png"
		},
		name = "rust",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "rusty metal"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_crate.png"
		},
		legacy_facedir_simple = true,
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_wood_footstep",
				gain = 1
			},
			dig = {
				name = "default_dig_choppy",
				gain = 0.4
			},
			footstep = {
				name = "default_wood_footstep",
				gain = 0.15
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "crate",
		description = "Crate"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octrng.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "octrng_pane_double",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.03125,
					0.5,
					1.5,
					0.03125
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Orange Octagon Glass pane"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_vent2.png"
		},
		name = "vent2",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "vent"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_widescreen.png"
		},
		light_source = 5,
		drawtype = "nodebox",
		sunlight_propagates = true,
		name = "widescreen",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.375,
					-0.3125,
					0.4375,
					0.375,
					0.3125,
					0.5
				},
				{
					-0.5,
					-0.375,
					0.375,
					-0.375,
					0.375,
					0.5
				},
				{
					0.375,
					-0.375,
					0.375,
					0.5,
					0.375,
					0.5
				},
				{
					-0.3125,
					0.25,
					0.375,
					0.3125,
					0.375,
					0.5
				},
				{
					-0.3125,
					-0.375,
					0.375,
					0.25,
					-0.25,
					0.5
				},
				{
					-0.5,
					-0.3125,
					0.375,
					0.5,
					-0.25,
					0.5
				},
				{
					-0.5,
					0.25,
					0.375,
					0.5,
					0.3125,
					0.5
				}
			}
		},
		paramtype = "light",
		description = "widescreen"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_rtop.png",
			"scifi_nodes_door_blue_top.png"
		},
		name = "blue_door_closed_top",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					0.5,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_orange.png"
		},
		light_source = 14,
		drawtype = "nodebox",
		sunlight_propagates = true,
		name = "liquid_pipe2",
		use_texture_alpha = "blend",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.375,
					-0.5,
					-0.375,
					0.375,
					0.5,
					0.375
				}
			}
		},
		paramtype = "light",
		description = "Liquid pipe 2"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_grey.png",
			"scifi_nodes_grey.png",
			"scifi_nodes_grey.png",
			"scifi_nodes_grey.png",
			"scifi_nodes_grey.png",
			"scifi_nodes_grey.png"
		},
		name = "table",
		sounds = {
			dug = {
				name = "default_dug_metal",
				gain = 0.5
			},
			dig = {
				name = "default_dig_metal",
				gain = 0.5
			},
			footstep = {
				name = "default_metal_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_metal",
				gain = 0.5
			}
		},
		paramtype = "light",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					0.4375,
					-0.5,
					0.5,
					0.5,
					0.5
				},
				{
					-0.0625,
					-0.5,
					0.125,
					0.0625,
					0.5,
					0.3125
				},
				{
					-0.0625,
					-0.5,
					0.375,
					0.0625,
					0.5,
					0.4375
				},
				{
					-0.0625,
					-0.375,
					0.0625,
					0.0625,
					0.4375,
					0.125
				},
				{
					-0.0625,
					-0.1875,
					0,
					0.0625,
					0.4375,
					0.0625
				},
				{
					-0.0625,
					0.0625,
					-0.0625,
					0.0625,
					0.4375,
					0
				},
				{
					-0.0625,
					0.25,
					-0.125,
					0.0625,
					0.4375,
					-0.0625
				}
			}
		},
		drawtype = "nodebox",
		description = "Metal table"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_rbottom0.png",
			"scifi_nodes_door_green_bottom0.png"
		},
		name = "green_door_opened",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					-0.25,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_flower1.png"
		},
		visual_scale = 1,
		light_source = 14,
		name = "flower1",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Glow Flower"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_greenpipe_front.png",
			"scifi_nodes_greenpipe_front.png",
			"scifi_nodes_greenpipe2_top.png",
			"scifi_nodes_greenpipe2_top.png",
			"scifi_nodes_greenpipe2_top.png",
			"scifi_nodes_greenpipe2_top.png"
		},
		name = "grnpipe2",
		sunlight_propagates = false,
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_dug_metal",
				gain = 0.5
			},
			dig = {
				name = "default_dig_metal",
				gain = 0.5
			},
			footstep = {
				name = "default_metal_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_metal",
				gain = 0.5
			}
		},
		paramtype = "light",
		description = "broken green pipe"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_blackdmgstripe.png"
		},
		name = "blackdmgstripe",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Damaged black wall(stripes)"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_ppllght.png"
		},
		light_source = 14,
		name = "ppllght",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Purple wall light"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_grey_square.png"
		},
		name = "grey_square",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "grey metal block"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_plant6.png"
		},
		visual_scale = 1,
		light_source = 10,
		name = "plant6",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Curly Plant"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_pwrstnd_top.png",
			"scifi_nodes_pwrstnd_top.png",
			"scifi_nodes_pwrstnd_side.png",
			"scifi_nodes_pwrstnd_side.png",
			"scifi_nodes_pwrstnd_side.png",
			"scifi_nodes_pwrstnd_side.png"
		},
		name = "powered_stand",
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.375,
					0.25,
					-0.3125,
					0.375,
					0.4375,
					0.3125
				},
				{
					-0.3125,
					0.25,
					-0.375,
					0.3125,
					0.4375,
					0.375
				},
				{
					-0.3125,
					0.4375,
					-0.3125,
					0.3125,
					0.5,
					0.3125
				},
				{
					-0.5,
					-0.5,
					-0.125,
					0.5,
					0.125,
					0.125
				},
				{
					-0.125,
					-0.5,
					-0.5,
					0.125,
					0.125,
					0.5
				},
				{
					-0.4375,
					0.125,
					-0.125,
					0.4375,
					0.25,
					0.125
				},
				{
					-0.125,
					0.125,
					-0.4375,
					0.125,
					0.25,
					0.4375
				},
				{
					-0.3125,
					-0.5,
					-0.375,
					0.3125,
					0.0625,
					0.3125
				},
				{
					-0.25,
					0.0625,
					-0.3125,
					0.25,
					0.125,
					0.3125
				}
			}
		},
		paramtype = "light",
		description = "powered stand"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_greenlights.png"
		},
		light_source = 10,
		name = "greenlights",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "green wall lights"
	})

klots.register_terrain({
		tiles = {
			"default_dirt.png^scifi_nodes_pot.png",
			"scifi_nodes_greybolts.png",
			"scifi_nodes_greybolts.png",
			"scifi_nodes_greybolts.png",
			"scifi_nodes_greybolts.png",
			"scifi_nodes_greybolts.png"
		},
		name = "pot",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.25,
					-0.5,
					0.5,
					0.5,
					0.5
				},
				{
					0.1875,
					-0.5,
					0.1875,
					0.5,
					-0.25,
					0.5
				},
				{
					-0.5,
					-0.5,
					-0.5,
					-0.1875,
					-0.25,
					-0.1875
				},
				{
					-0.5,
					-0.5,
					0.1875,
					-0.1875,
					-0.25,
					0.5
				},
				{
					0.1875,
					-0.5,
					-0.5,
					0.5,
					-0.25,
					-0.1875
				}
			}
		},
		paramtype = "light",
		sounds = {
			dug = {
				name = "default_dug_metal",
				gain = 0.5
			},
			dig = {
				name = "default_dig_metal",
				gain = 0.5
			},
			footstep = {
				name = "default_metal_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_metal",
				gain = 0.5
			}
		},
		drawtype = "nodebox",
		description = "Metal Plant Pot (right-click for lid, sneak + right-click to plant)"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octofloor.png"
		},
		name = "octofloor",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Doom floor"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_wall.png"
		},
		name = "wall",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "metal wall"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_greygreenbar.png"
		},
		light_source = 10,
		name = "greygreenbar",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "gray power pipe"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_greenmetal.png"
		},
		name = "greenmetal",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "green metal wall"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_blacktile2.png"
		},
		name = "blacktile2",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "black tile 2"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_blackoct.png"
		},
		name = "blackoct",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "black octagon"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_green2.png"
		},
		name = "green2",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "green wall panel"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_lighttop.png"
		},
		name = "lighttop",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "metal block"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_blackplate.png"
		},
		light_source = 0,
		name = "blackplate",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Black plate"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_doomwall43.png"
		},
		name = "doomwall43",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Doom wall 4.3"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_green_square.png"
		},
		name = "green_square",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "green metal block"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_rtop.png",
			"scifi_nodes_door_Doom_top.png"
		},
		name = "Doom_door_closed_top",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					0.5,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_box.png",
			"scifi_nodes_box.png",
			"scifi_nodes_box.png",
			"scifi_nodes_box.png"
		},
		legacy_facedir_simple = true,
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_dug_metal",
				gain = 0.5
			},
			dig = {
				name = "default_dig_metal",
				gain = 0.5
			},
			footstep = {
				name = "default_metal_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_metal",
				gain = 0.5
			}
		},
		name = "box",
		description = "Storage box"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_green.png"
		},
		name = "green",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "green lines"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_plant8.png"
		},
		visual_scale = 1,
		light_source = 10,
		name = "plant8",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Slug weed"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_whiteoct.png"
		},
		light_source = 0,
		name = "whiteoct",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "white octagon"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_wallpipe.png",
			"scifi_nodes_wallpipe.png",
			"scifi_nodes_wallpipe.png",
			"scifi_nodes_wallpipe.png",
			"scifi_nodes_wallpipe.png",
			"scifi_nodes_wallpipe.png"
		},
		name = "wallpipe",
		sounds = {
			dug = {
				name = "default_wood_footstep",
				gain = 1
			},
			dig = {
				name = "default_dig_choppy",
				gain = 0.4
			},
			footstep = {
				name = "default_wood_footstep",
				gain = 0.15
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					0.125,
					0.5,
					0.5,
					0.5
				},
				{
					-0.1875,
					-0.5,
					-0.0625,
					0.1875,
					0.5,
					0.125
				},
				{
					-0.125,
					-0.5,
					-0.125,
					0.125,
					0.5,
					0.125
				},
				{
					0.3125,
					-0.5,
					0.0625,
					0.4375,
					0.5,
					0.125
				},
				{
					-0.4375,
					-0.5,
					0.0625,
					-0.3125,
					0.5,
					0.125
				},
				{
					-0.5,
					0.0625,
					0,
					0.5,
					0.1875,
					0.0625
				},
				{
					-0.5,
					-0.125,
					0,
					0.5,
					0,
					0.0625
				}
			}
		},
		drawtype = "nodebox",
		description = "Alien wall pipe"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_flower4.png"
		},
		visual_scale = 1.5,
		light_source = 0,
		name = "flower4",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Weeping flower"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_engine.png"
		},
		name = "engine",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "engine"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_glass.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "glass_pane_double",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.03125,
					0.5,
					1.5,
					0.03125
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Dark Glass pane"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_whitetile.png"
		},
		light_source = 0,
		name = "whitetile",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "white tile2"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_glscrn.png",
			"scifi_nodes_glscrn.png",
			"scifi_nodes_glscrn.png",
			"scifi_nodes_glscrn.png",
			"scifi_nodes_glscrn.png",
			"scifi_nodes_glscrn.png"
		},
		light_source = 14,
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "glassscreen",
		use_texture_alpha = "blend",
		sunlight_propagates = true,
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.4375,
					-0.5,
					-0.125,
					0.4375,
					-0.1875,
					0.0625
				},
				{
					-0.375,
					-0.5,
					-0.0625,
					0.375,
					0.5,
					0
				}
			}
		},
		paramtype = "light",
		description = "glass screen"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_stripes2top.png",
			"scifi_nodes_stripes2top.png",
			"scifi_nodes_stripes2.png",
			"scifi_nodes_stripes2.png",
			"scifi_nodes_stripes2.png",
			"scifi_nodes_stripes2.png"
		},
		name = "stripes2",
		sounds = {
			dug = {
				name = "default_dug_metal",
				gain = 0.5
			},
			dig = {
				name = "default_dig_metal",
				gain = 0.5
			},
			footstep = {
				name = "default_metal_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_metal",
				gain = 0.5
			}
		},
		sunlight_propagates = false,
		paramtype = "light",
		description = "hazard stripes2"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octrng.png"
		},
		light_source = 10,
		drawtype = "glasslike",
		sunlight_propagates = false,
		name = "octrng",
		use_texture_alpha = "blend",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Orange Octagon Glass"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_plant1.png"
		},
		visual_scale = 1,
		light_source = 0,
		name = "plant1",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Bulb Plant"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_blackvent.png",
			"scifi_nodes_black.png",
			"scifi_nodes_mesh2.png",
			"scifi_nodes_pc.png"
		},
		name = "computer",
		sunlight_propagates = true,
		paramtype = "light",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.4375,
					-0.5,
					-0.5,
					0.0625,
					0.5,
					0.5
				}
			}
		},
		drawtype = "nodebox",
		description = "computer"
	})

klots.register_terrain({
		tiles = {
			"default_grass.png^[colorize:cyan:80",
			"default_dirt.png",
			{
				name = "default_dirt.png^(default_grass_side.png^[colorize:cyan:80)",
				tileable_vertical = false
			}
		},
		name = "grassblk",
		light_source = 2,
		description = "Dirt With Alien Grass"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_builder.png",
			"scifi_nodes_builder.png",
			"scifi_nodes_builder_side.png",
			"scifi_nodes_builder_side.png",
			"scifi_nodes_builder_side.png",
			"scifi_nodes_builder_front.png"
		},
		paramtype2 = "facedir",
		name = "builder",
		paramtype = "light",
		description = "Sci-fi Node Builder"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_pplwll2.png"
		},
		light_source = 0,
		name = "pplwll2",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Purple wall2"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_doomwall431.png"
		},
		name = "doomwall431",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Doom wall 4.3.1"
	})

klots.register_terrain({
		tiles = {
			{
				name = "scifi_nodes_black_screen.png",
				animation = {
					type = "vertical_frames",
					length = 2,
					aspect_h = 16,
					aspect_w = 16
				}
			}
		},
		light_source = 1,
		name = "black_screen",
		sounds = {
			dug = {
				name = "default_hard_footstep",
				gain = 1
			},
			footstep = {
				name = "default_hard_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		sunlight_propagates = false,
		paramtype = "light",
		description = "black wall screen"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_doomwall44.png"
		},
		name = "doomwall44",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Doom wall 4.4"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_glassstrngsd4.png",
			"scifi_nodes_black.png",
			"scifi_nodes_glassstrng2.png",
			"scifi_nodes_glassstrng2.png",
			"scifi_nodes_glassstrngsd3.png",
			"scifi_nodes_glassstrngsd3.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "windowstraight2",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.3125,
					-0.5,
					-0.5,
					0.3125,
					-0.25,
					0.5
				},
				{
					-0.0625,
					-0.5,
					-0.5,
					0.0625,
					0.5,
					0.5
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "strong window(black)"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octgrn.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "octgrn_pane_offset",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					0.96875,
					0.5,
					0.5,
					1.03125
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Green Octagon Glass pane"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_glass.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "glass_pane_offset",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					0.96875,
					0.5,
					0.5,
					1.03125
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Dark Glass pane"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octppl.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "octppl_pane",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.03125,
					0.5,
					0.5,
					0.03125
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Purple Octagon Glass pane"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octbl.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "octbl_pane_double",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.03125,
					0.5,
					1.5,
					0.03125
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Blue Octagon Glass pane"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_bluwllight.png"
		},
		light_source = 14,
		name = "bluwllight",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Blue wall light"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octgrn.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "octgrn_pane_double",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.03125,
					0.5,
					1.5,
					0.03125
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Green Octagon Glass pane"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octgrn.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "octgrn_pane",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.03125,
					0.5,
					0.5,
					0.03125
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Green Octagon Glass pane"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octrng.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "octrng_pane_offset",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					0.96875,
					0.5,
					0.5,
					1.03125
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Orange Octagon Glass pane"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octrng.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "octrng_pane",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.03125,
					0.5,
					0.5,
					0.03125
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Orange Octagon Glass pane"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octppl.png"
		},
		light_source = 10,
		drawtype = "glasslike",
		sunlight_propagates = false,
		name = "octppl",
		use_texture_alpha = "blend",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Purple Octagon Glass"
	})

klots.register_terrain({
		node_box = {
			type = "wallmounted"
		},
		drawtype = "signlike",
		sunlight_propagates = true,
		name = "palm_scanner_off",
		tiles = {
			"scifi_nodes_palm_scanner_off.png"
		},
		paramtype2 = "wallmounted",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Palm scanner"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_plant5.png"
		},
		visual_scale = 1.7,
		light_source = 0,
		name = "plant5",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Fern Plant"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_mesh2.png"
		},
		name = "mesh2",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "metal floormesh"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_doomwall4.png"
		},
		name = "doomwall4",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Doom wall 4"
	})

klots.register_terrain({
		node_box = {
			type = "wallmounted"
		},
		drawtype = "signlike",
		sunlight_propagates = true,
		name = "digicode_off",
		tiles = {
			"scifi_nodes_digicode_off.png"
		},
		paramtype2 = "wallmounted",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Digicode"
	})

klots.register_terrain({
		node_box = {
			type = "wallmounted"
		},
		light_source = 5,
		drawtype = "signlike",
		sunlight_propagates = true,
		name = "digicode_on",
		tiles = {
			"scifi_nodes_digicode_on.png"
		},
		paramtype2 = "wallmounted",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Digicode"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_traplant_top.png",
			"scifi_nodes_traplant_side.png",
			"scifi_nodes_traplant_side.png",
			"scifi_nodes_traplant_side.png",
			"scifi_nodes_traplant_side.png",
			"scifi_nodes_traplant_side.png"
		},
		light_source = 5,
		drawtype = "nodebox",
		sunlight_propagates = false,
		walkable = false,
		name = "plant_trap",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.125,
					-0.4375,
					-0.125,
					0.125,
					0.125,
					0.125
				},
				{
					-0.1875,
					0.125,
					-0.1875,
					0.1875,
					0.1875,
					0.1875
				},
				{
					-0.0625,
					-0.5,
					-0.0625,
					0,
					-0.4375,
					0.375
				},
				{
					-0.0625,
					-0.5,
					0.3125,
					0,
					0.5,
					0.375
				}
			}
		},
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_wood_footstep",
				gain = 1
			},
			dig = {
				name = "default_dig_choppy",
				gain = 0.4
			},
			footstep = {
				name = "default_wood_footstep",
				gain = 0.15
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Hanging Trap Plant"
	})

klots.register_terrain({
		tiles = {
			{
				name = "scifi_nodes_palm_scanner_checking.png",
				animation = {
					type = "vertical_frames",
					length = 1.5,
					aspect_h = 16,
					aspect_w = 16
				}
			}
		},
		drawtype = "signlike",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "palm_scanner_checking",
		node_box = {
			type = "wallmounted"
		},
		paramtype2 = "wallmounted",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Palm scanner"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_glass.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "windowpanel",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.0625,
					-0.5,
					-0.5,
					0.0625,
					0.5,
					0.5
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "strong window panel"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_tallscreen.png"
		},
		light_source = 5,
		drawtype = "nodebox",
		sunlight_propagates = true,
		name = "tallscreen",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.3125,
					-0.375,
					0.4375,
					0.3125,
					0.375,
					0.5
				},
				{
					-0.375,
					0.375,
					0.375,
					0.375,
					0.5,
					0.5
				},
				{
					-0.375,
					-0.5,
					0.375,
					0.375,
					-0.375,
					0.5
				},
				{
					0.25,
					-0.3125,
					0.375,
					0.375,
					0.3125,
					0.5
				},
				{
					-0.375,
					-0.25,
					0.375,
					-0.25,
					0.3125,
					0.5
				},
				{
					-0.3125,
					-0.5,
					0.375,
					-0.25,
					0.5,
					0.5
				},
				{
					0.25,
					-0.5,
					0.375,
					0.3125,
					0.5,
					0.5
				}
			}
		},
		paramtype = "light",
		description = "tallscreen"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png"
		},
		name = "itemholder",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.3125,
					-0.5,
					-0.3125,
					0.3125,
					-0.25,
					0.3125
				},
				{
					-0.0625,
					-0.5,
					0.1875,
					0.0625,
					-0.0625,
					0.25
				},
				{
					-0.0625,
					-0.5,
					-0.25,
					0.0625,
					-0.0625,
					-0.1875
				},
				{
					0.1875,
					-0.5,
					-0.0625,
					0.25,
					-0.0625,
					0.0625
				},
				{
					-0.25,
					-0.5,
					-0.0625,
					-0.1875,
					-0.0625,
					0.0625
				}
			}
		},
		paramtype = "light",
		sunlight_propagates = true,
		drawtype = "nodebox",
		description = "item holder"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_capsule2.png",
			"scifi_nodes_capsule2.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_capsule2.png",
			"scifi_nodes_capsule2.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sunlight_propagates = true,
		name = "capsule2",
		node_box = {
			type = "fixed",
			fixed = {
				{
					0.3125,
					-0.5,
					-0.25,
					0.5,
					0,
					0.25
				},
				{
					-0.5,
					-0.5,
					-0.25,
					-0.3125,
					0,
					0.25
				},
				{
					-0.3125,
					-0.4375,
					-0.1875,
					0.3125,
					-0.0625,
					0.1875
				}
			}
		},
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "sample capsule"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_capsule3.png",
			"scifi_nodes_capsule3.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_capsule3.png",
			"scifi_nodes_capsule3.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sunlight_propagates = true,
		name = "capsule3",
		node_box = {
			type = "fixed",
			fixed = {
				{
					0.3125,
					-0.5,
					-0.25,
					0.5,
					0,
					0.25
				},
				{
					-0.5,
					-0.5,
					-0.25,
					-0.3125,
					0,
					0.25
				},
				{
					-0.3125,
					-0.4375,
					-0.1875,
					0.3125,
					-0.0625,
					0.1875
				}
			}
		},
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "sample capsule"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_greenbar.png",
			"scifi_nodes_greenbar.png",
			{
				name = "scifi_nodes_greenbar_animated.png",
				animation = {
					type = "vertical_frames",
					length = 1,
					aspect_h = 16,
					aspect_w = 16
				}
			}
		},
		name = "greenbar_animated",
		light_source = 10,
		sunlight_propagates = false,
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "animated green light bar"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_tile.png"
		},
		name = "tile",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "white tile"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_flower3.png"
		},
		visual_scale = 2,
		light_source = 0,
		name = "flower3",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Triffid"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_glassstrngsd4.png",
			"scifi_nodes_black.png",
			"scifi_nodes_glassstrngcrnr3.png",
			"scifi_nodes_glassstrngcrnr4.png",
			"scifi_nodes_black.png",
			"scifi_nodes_glassstrngsd3.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "windowcorner2",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.3125,
					-0.5,
					-0.5,
					0.3125,
					-0.25,
					0.5
				},
				{
					-0.3125,
					-0.25,
					0.25,
					0.3125,
					-0.1875,
					0.5
				},
				{
					-0.3125,
					-0.25,
					0.3125,
					0.3125,
					-0.125,
					0.375
				},
				{
					-0.3125,
					-0.3125,
					0.25,
					0.3125,
					-0.1875,
					0.3125
				},
				{
					-0.3125,
					-0.5,
					0.375,
					0.3125,
					0.5,
					0.5
				},
				{
					-0.0625,
					-0.5,
					-0.5,
					0.0625,
					0.5,
					0.5
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "strong window corner(black)"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_glassstrngsd2.png",
			"scifi_nodes_white.png",
			"scifi_nodes_glassstrng.png",
			"scifi_nodes_glassstrng.png",
			"scifi_nodes_glassstrngsd.png",
			"scifi_nodes_glassstrngsd.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "windowstraight",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.3125,
					-0.5,
					-0.5,
					0.3125,
					-0.25,
					0.5
				},
				{
					-0.0625,
					-0.5,
					-0.5,
					0.0625,
					0.5,
					0.5
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "strong window"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_glassstrngsd2.png",
			"scifi_nodes_white.png",
			"scifi_nodes_glassstrngcrnr.png",
			"scifi_nodes_glassstrngcrnr2.png",
			"scifi_nodes_white.png",
			"scifi_nodes_glassstrngsd.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "windowcorner",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.3125,
					-0.5,
					-0.5,
					0.3125,
					-0.25,
					0.5
				},
				{
					-0.3125,
					-0.25,
					0.25,
					0.3125,
					-0.1875,
					0.5
				},
				{
					-0.3125,
					-0.25,
					0.3125,
					0.3125,
					-0.125,
					0.375
				},
				{
					-0.3125,
					-0.3125,
					0.25,
					0.3125,
					-0.1875,
					0.3125
				},
				{
					-0.3125,
					-0.5,
					0.375,
					0.3125,
					0.5,
					0.5
				},
				{
					-0.0625,
					-0.5,
					-0.5,
					0.0625,
					0.5,
					0.5
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "strong window corner"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_blacktile2.png",
			"scifi_nodes_blacktile2.png",
			"scifi_nodes_pipen.png",
			"scifi_nodes_pipen.png",
			"scifi_nodes_pipen.png",
			"scifi_nodes_pipen.png"
		},
		name = "pipen",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.4375,
					-0.5,
					-0.4375,
					0.4375,
					0.5,
					0.4375
				},
				{
					-0.5,
					0.4375,
					-0.5,
					0.5,
					0.5,
					0.5
				},
				{
					-0.5,
					0.3125,
					-0.5,
					0.5,
					0.375,
					0.5
				},
				{
					-0.5,
					0.1875,
					-0.5,
					0.5,
					0.25,
					0.5
				},
				{
					-0.5,
					0.0625,
					-0.5,
					0.5,
					0.125,
					0.5
				},
				{
					-0.5,
					-0.0625,
					-0.5,
					0.5,
					0,
					0.5
				},
				{
					-0.5,
					-0.1875,
					-0.5,
					0.5,
					-0.125,
					0.5
				},
				{
					-0.5,
					-0.3125,
					-0.5,
					0.5,
					-0.25,
					0.5
				},
				{
					-0.5,
					-0.4375,
					-0.5,
					0.5,
					-0.375,
					0.5
				}
			}
		},
		paramtype2 = "facedir",
		paramtype = "light",
		drawtype = "nodebox",
		description = "pipe(nodebox)"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_lapkey.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_laptop.png"
		},
		name = "laptop_open",
		sunlight_propagates = true,
		paramtype = "light",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.4375,
					-0.5,
					-0.4375,
					0.4375,
					-0.375,
					0.3125
				},
				{
					-0.4375,
					-0.375,
					0.3125,
					0.4375,
					0.4375,
					0.4375
				}
			}
		},
		drawtype = "nodebox",
		description = "laptop"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_white.png",
			"scifi_nodes_black.png",
			"scifi_nodes_white_vent.png",
			"scifi_nodes_white_vent.png",
			"scifi_nodes_white_vent.png",
			"scifi_nodes_white_vent.png"
		},
		name = "microscope",
		sunlight_propagates = true,
		paramtype = "light",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.25,
					-0.5,
					-0.3125,
					0.25,
					-0.375,
					0.3125
				},
				{
					-0.0625,
					-0.5,
					0.125,
					0.0625,
					0.3125,
					0.25
				},
				{
					-0.0625,
					-0.0625,
					-0.0625,
					0.0625,
					0.5,
					0.0625
				},
				{
					-0.0625,
					0.0625,
					0.0625,
					0.0625,
					0.25,
					0.125
				},
				{
					-0.125,
					-0.25,
					-0.125,
					0.125,
					-0.1875,
					0.1875
				}
			}
		},
		drawtype = "nodebox",
		description = "Microscope"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_orange2.png"
		},
		light_source = 14,
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "lightbars",
		use_texture_alpha = "blend",
		node_box = {
			type = "fixed",
			fixed = {
				{
					0.125,
					-0.5,
					0.125,
					0.375,
					0.5,
					0.375
				},
				{
					-0.375,
					-0.5,
					0.125,
					-0.125,
					0.5,
					0.375
				},
				{
					-0.375,
					-0.5,
					-0.375,
					-0.125,
					0.5,
					-0.125
				},
				{
					0.125,
					-0.5,
					-0.375,
					0.375,
					0.5,
					-0.125
				}
			}
		},
		paramtype = "light",
		description = "orange lightbars"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_white2.png",
			"scifi_nodes_white2.png",
			"scifi_nodes_white_side.png",
			"scifi_nodes_white_side.png",
			"scifi_nodes_white_side.png",
			"scifi_nodes_white_side.png"
		},
		name = "white_base",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = false,
		paramtype = "light",
		description = "white wall base"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_white2.png"
		},
		light_source = 14,
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "lightbar",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.125,
					-0.5,
					-0.5,
					0.125,
					-0.375,
					0.5
				}
			}
		},
		paramtype2 = "wallmounted",
		sunlight_propagates = true,
		paramtype = "light",
		description = "ceiling light"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_stripes.png"
		},
		name = "stripes",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "hazard stripes"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_gloshroom.png",
			"scifi_nodes_gloshroom_under.png",
			"scifi_nodes_gloshroom.png",
			"scifi_nodes_gloshroom.png",
			"scifi_nodes_gloshroom.png",
			"scifi_nodes_gloshroom.png"
		},
		light_source = 14,
		drawtype = "nodebox",
		sunlight_propagates = false,
		walkable = false,
		name = "gloshroom",
		use_texture_alpha = "blend",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.05,
					-0.5,
					-0.05,
					0.05,
					0.0625,
					0.05
				},
				{
					-0.4375,
					-0.0625,
					-0.375,
					0.4375,
					0,
					0.375
				},
				{
					-0.375,
					0,
					-0.375,
					0.375,
					0.0625,
					0.375
				},
				{
					-0.3125,
					0.0625,
					-0.3125,
					0.3125,
					0.125,
					0.3125
				},
				{
					-0.1875,
					0.125,
					-0.1875,
					0.1875,
					0.1875,
					0.1875
				},
				{
					-0.375,
					-0.0625,
					-0.4375,
					0.375,
					0,
					0.4375
				}
			}
		},
		paramtype = "light",
		description = "Gloshroom"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_rtopo.png",
			"scifi_nodes_door_blue_topo.png"
		},
		name = "blue_door_opened_top",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					-0.25,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_red_square.png"
		},
		name = "red_square",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "red metal block"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_rbottom0.png",
			"scifi_nodes_door_blue_bottom0.png"
		},
		name = "blue_door_opened",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					-0.25,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_rtopo.png",
			"scifi_nodes_door_green_topo.png"
		},
		name = "green_door_opened_top",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					-0.25,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_rtop.png",
			"scifi_nodes_door_green_top.png"
		},
		name = "green_door_closed_top",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					0.5,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_rtopo.png",
			"scifi_nodes_door_black_topo.png"
		},
		name = "black_door_opened_top",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					-0.25,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_rtopo.png",
			"scifi_nodes_door_white_topo.png"
		},
		name = "white_door_opened_top",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					-0.25,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_rtop.png",
			"scifi_nodes_door_white_top.png"
		},
		name = "white_door_closed_top",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					0.5,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_greydots.png"
		},
		name = "greydots",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "grey wall dots"
	})

klots.register_terrain({
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					0.5,
					0.5,
					0.0625
				}
			}
		},
		name = "green_door_closed",
		tiles = {
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_rbottom.png",
			"scifi_nodes_door_green_bottom.png"
		},
		paramtype2 = "facedir",
		drawtype = "nodebox",
		paramtype = "light",
		description = "green sliding door"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_rbottom0.png",
			"scifi_nodes_door_black_bottom0.png"
		},
		name = "black_door_opened",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					-0.25,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_rtop.png",
			"scifi_nodes_door_black_top.png"
		},
		name = "black_door_closed_top",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					0.5,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox"
	})

klots.register_terrain({
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					0.5,
					0.5,
					0.0625
				}
			}
		},
		name = "black_door_closed",
		tiles = {
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_rbottom.png",
			"scifi_nodes_door_black_bottom.png"
		},
		paramtype2 = "facedir",
		drawtype = "nodebox",
		paramtype = "light",
		description = "black sliding door"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_gblock2_top.png",
			"scifi_nodes_gblock.png",
			"scifi_nodes_gblock2.png",
			"scifi_nodes_gblock2_fx.png",
			"scifi_nodes_gblock.png",
			"scifi_nodes_gblock2_front1.png"
		},
		name = "gblock2",
		sounds = {
			dug = {
				name = "default_dug_metal",
				gain = 0.5
			},
			dig = {
				name = "default_dig_metal",
				gain = 0.5
			},
			footstep = {
				name = "default_metal_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_metal",
				gain = 0.5
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = false,
		paramtype = "light",
		description = "Green metal block 2"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_stripes2top.png"
		},
		name = "stripes2top",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "dirty metal block"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_rtopo.png",
			"scifi_nodes_door_Doom_topo.png"
		},
		name = "Doom_door_opened_top",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					-0.25,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_rbottom0.png",
			"scifi_nodes_door_Doom_bottom0.png"
		},
		name = "Doom_door_opened",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.0625,
					-0.25,
					0.5,
					0.0625
				}
			}
		},
		paramtype = "light",
		drawtype = "nodebox"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_blackvnt.png"
		},
		light_source = 0,
		name = "blackvnt",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Black vent"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_rock2.png"
		},
		light_source = 0,
		name = "rock2",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Moonstone2"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_fan.png"
		},
		name = "fan",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Fan"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_pplwll4.png"
		},
		light_source = 0,
		name = "pplwll4",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Purple wall4"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_pplwll3.png"
		},
		light_source = 0,
		name = "pplwll3",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Purple wall3"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_junk.png"
		},
		name = "junk",
		sounds = {
			dug = {
				name = "default_dug_metal",
				gain = 0.5
			},
			dig = {
				name = "default_dig_metal",
				gain = 0.5
			},
			footstep = {
				name = "default_metal_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_metal",
				gain = 0.5
			}
		},
		description = "Junk"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_rough.png"
		},
		name = "rough",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "rough metal"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_pplblk.png"
		},
		light_source = 0,
		name = "pplblk",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Purple tile"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_doomwall2.png"
		},
		name = "doomwall2",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Doom wall 2"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_gblock2_top.png",
			"scifi_nodes_gblock.png",
			"scifi_nodes_gblock2.png",
			"scifi_nodes_gblock2_fx.png",
			"scifi_nodes_gblock.png",
			"scifi_nodes_gblock2_screen.png"
		},
		name = "gblock3",
		sounds = {
			dug = {
				name = "default_dug_metal",
				gain = 0.5
			},
			dig = {
				name = "default_dig_metal",
				gain = 0.5
			},
			footstep = {
				name = "default_metal_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_metal",
				gain = 0.5
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = false,
		paramtype = "light",
		description = "Green metal block 3"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_bluetile.png"
		},
		name = "bluetile",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "blue tile"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_eyetree.png"
		},
		visual_scale = 2.5,
		light_source = 0,
		name = "eyetree",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Eye Tree"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_mesh.png"
		},
		name = "mesh",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "metal mesh"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octgrn.png"
		},
		light_source = 10,
		drawtype = "glasslike",
		sunlight_propagates = false,
		name = "octgrn",
		use_texture_alpha = "blend",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Green Octagon Glass"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_capsule.png",
			"scifi_nodes_capsule.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_capsule.png",
			"scifi_nodes_capsule.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sunlight_propagates = true,
		name = "capsule",
		node_box = {
			type = "fixed",
			fixed = {
				{
					0.3125,
					-0.5,
					-0.25,
					0.5,
					0,
					0.25
				},
				{
					-0.5,
					-0.5,
					-0.25,
					-0.3125,
					0,
					0.25
				},
				{
					-0.3125,
					-0.4375,
					-0.1875,
					0.3125,
					-0.0625,
					0.1875
				}
			}
		},
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "sample capsule"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_black.png"
		},
		name = "black",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "black wall"
	})

klots.register_terrain({
		node_box = {
			type = "wallmounted"
		},
		drawtype = "signlike",
		sunlight_propagates = true,
		name = "switch_off",
		tiles = {
			"scifi_nodes_switch_off.png"
		},
		paramtype2 = "wallmounted",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Wall switch"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octbl.png"
		},
		light_source = 10,
		drawtype = "glasslike",
		sunlight_propagates = false,
		name = "octbl",
		use_texture_alpha = "blend",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Blue Octagon Glass"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_doomlight.png"
		},
		light_source = 12,
		name = "doomlight",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Doom light"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_white2.png"
		},
		light_source = 0,
		name = "white2",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "plastic"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_super_white.png"
		},
		light_source = 11,
		name = "super_white",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Super Plastic"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_alnslp_top2.png",
			"scifi_nodes_alnslp_top.png",
			"scifi_nodes_alnslp.png",
			"scifi_nodes_alnslp.png",
			"scifi_nodes_alnslp_top.png",
			"scifi_nodes_alnslp_top.png"
		},
		name = "alienslope",
		sounds = {
			dug = {
				name = "default_wood_footstep",
				gain = 1
			},
			dig = {
				name = "default_dig_choppy",
				gain = 0.4
			},
			footstep = {
				name = "default_wood_footstep",
				gain = 0.15
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		paramtype2 = "facedir",
		node_box = {
			type = "fixed",
			fixed = {
				{
					0,
					-0.5,
					-0.5,
					0.5,
					0.5,
					0.5
				},
				{
					-0.5,
					-0.5,
					-0.5,
					0,
					-0.25,
					0.5
				},
				{
					-0.4375,
					-0.25,
					-0.5,
					0,
					-0.125,
					0.5
				},
				{
					-0.375,
					-0.125,
					-0.5,
					0,
					0,
					0.5
				},
				{
					-0.3125,
					0,
					-0.5,
					0,
					0.125,
					0.5
				},
				{
					-0.25,
					0.125,
					-0.5,
					0,
					0.25,
					0.5
				},
				{
					-0.1875,
					0.25,
					-0.5,
					0.0625,
					0.375,
					0.5
				},
				{
					-0.125,
					0.375,
					-0.5,
					0.5,
					0.5,
					0.5
				}
			}
		},
		drawtype = "nodebox",
		description = "Alien Platform"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_screen3.png"
		},
		name = "screen3",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Wall monitor"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_pipe.png"
		},
		name = "pipe",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "wall pipe"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_black_detail.png"
		},
		name = "black_detail",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "black detail"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_bluebars.png"
		},
		name = "bluebars",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "blue bars"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_ladder.png"
		},
		drawtype = "nodebox",
		walkable = false,
		name = "ladder",
		paramtype = "light",
		paramtype2 = "wallmounted",
		node_box = {
			type = "fixed",
			sounds = {
				dug = {
					name = "default_dug_metal",
					gain = 0.5
				},
				dig = {
					name = "default_dig_metal",
					gain = 0.5
				},
				footstep = {
					name = "default_metal_footstep",
					gain = 0.2
				},
				place = {
					name = "default_place_node_metal",
					gain = 0.5
				}
			},
			fixed = {
				{
					0.3125,
					-0.5,
					-0.4375,
					0.4375,
					-0.375,
					-0.3125
				},
				{
					-0.4375,
					-0.5,
					-0.4375,
					-0.3125,
					-0.375,
					-0.3125
				},
				{
					-0.375,
					-0.375,
					-0.4375,
					0.375,
					-0.3125,
					-0.3125
				},
				{
					-0.375,
					-0.375,
					0.3125,
					0.375,
					-0.3125,
					0.4375
				},
				{
					-0.375,
					-0.375,
					0.0625,
					0.375,
					-0.3125,
					0.1875
				},
				{
					-0.375,
					-0.375,
					-0.1875,
					0.375,
					-0.3125,
					-0.0625
				},
				{
					-0.4375,
					-0.5,
					-0.1875,
					-0.3125,
					-0.375,
					-0.0625
				},
				{
					-0.4375,
					-0.5,
					0.0625,
					-0.3125,
					-0.375,
					0.1875
				},
				{
					-0.4375,
					-0.5,
					0.3125,
					-0.3125,
					-0.375,
					0.4375
				},
				{
					0.3125,
					-0.5,
					0.3125,
					0.4375,
					-0.375,
					0.4375
				},
				{
					0.3125,
					-0.5,
					0.0625,
					0.4375,
					-0.375,
					0.1875
				},
				{
					0.3125,
					-0.5,
					-0.1875,
					0.4375,
					-0.375,
					-0.0625
				}
			}
		},
		climbable = true,
		description = "Metal Ladder"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_rustfloor.png"
		},
		light_source = 10,
		name = "rfloor",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_dug_metal",
				gain = 0.5
			},
			dig = {
				name = "default_dig_metal",
				gain = 0.5
			},
			footstep = {
				name = "default_metal_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_metal",
				gain = 0.5
			}
		},
		paramtype = "light",
		description = "rusty floor"
	})

klots.register_terrain({
		node_box = {
			type = "wallmounted"
		},
		drawtype = "signlike",
		sunlight_propagates = true,
		name = "protected_switch_off",
		tiles = {
			"scifi_nodes_switch_off.png"
		},
		paramtype2 = "wallmounted",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Protected wall switch"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_white.png"
		},
		light_source = 0,
		name = "white",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "plastic wall"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_gblock.png",
			"scifi_nodes_gblock.png",
			"scifi_nodes_gblock.png",
			"scifi_nodes_gblock.png",
			"scifi_nodes_gblock.png",
			"scifi_nodes_gblock.png"
		},
		name = "gblock",
		sounds = {
			dug = {
				name = "default_dug_metal",
				gain = 0.5
			},
			dig = {
				name = "default_dig_metal",
				gain = 0.5
			},
			footstep = {
				name = "default_metal_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_metal",
				gain = 0.5
			}
		},
		sunlight_propagates = false,
		paramtype = "light",
		description = "Green metal block"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octofloor2.png"
		},
		name = "octofloor2",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Brown Doom floor"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_octbl.png"
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "octbl_pane",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.03125,
					0.5,
					0.5,
					0.03125
				}
			}
		},
		paramtype2 = "facedir",
		sunlight_propagates = true,
		paramtype = "light",
		description = "Blue Octagon Glass pane"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_bluegrid.png"
		},
		light_source = 5,
		name = "bluegrid",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Blue Grid"
	})

klots.register_terrain({
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.4375,
					-1.5,
					-0.4375,
					0.4375,
					-0.5,
					-0.375
				},
				{
					-0.4375,
					-1.5,
					0.375,
					0.4375,
					-0.5,
					0.4375
				},
				{
					-0.4375,
					-1.5,
					-0.375,
					-0.375,
					-0.5,
					0.375
				},
				{
					0.375,
					-1.5,
					-0.375,
					0.4375,
					-0.5,
					0.375
				},
				{
					-0.375,
					-0.5,
					-0.375,
					0.375,
					-0.4375,
					0.375
				},
				{
					-0.3125,
					-0.4375,
					-0.3125,
					0.3125,
					-0.375,
					0.3125
				},
				{
					-0.25,
					-0.375,
					-0.25,
					0.25,
					-0.3125,
					0.25
				},
				{
					-0.1875,
					-0.3125,
					-0.1875,
					0.1875,
					-0.25,
					0.1875
				}
			}
		},
		use_texture_alpha = "blend",
		drawtype = "nodebox",
		sunlight_propagates = true,
		name = "pot_lid",
		tiles = {
			"scifi_nodes_glass2.png"
		},
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Plant Pot Lid"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_bluefloor.png"
		},
		light_source = 10,
		name = "bfloor",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_dug_metal",
				gain = 0.5
			},
			dig = {
				name = "default_dig_metal",
				gain = 0.5
			},
			footstep = {
				name = "default_metal_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_metal",
				gain = 0.5
			}
		},
		paramtype = "light",
		description = "blue floor"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_plant4.png"
		},
		visual_scale = 1.2,
		light_source = 10,
		name = "plant4",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Green Jelly Plant"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_lighttop.png",
			"scifi_nodes_lighttop.png",
			"scifi_nodes_redlight.png",
			"scifi_nodes_redlight.png",
			"scifi_nodes_redlight.png",
			"scifi_nodes_redlight.png"
		},
		light_source = 10,
		name = "red_light",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		sunlight_propagates = false,
		paramtype = "light",
		description = "red lightbox"
	})

klots.register_terrain({
		tiles = {
			"default_dirt.png^scifi_nodes_pot2.png",
			"scifi_nodes_greybolts.png",
			"scifi_nodes_greybolts.png",
			"scifi_nodes_greybolts.png",
			"scifi_nodes_greybolts.png",
			"scifi_nodes_greybolts.png"
		},
		name = "pot2",
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.25,
					-0.5,
					0.5,
					0.5,
					0.5
				},
				{
					0.1875,
					-0.5,
					0.1875,
					0.5,
					-0.25,
					0.5
				},
				{
					-0.5,
					-0.5,
					-0.5,
					-0.1875,
					-0.25,
					-0.1875
				},
				{
					-0.5,
					-0.5,
					0.1875,
					-0.1875,
					-0.25,
					0.5
				},
				{
					0.1875,
					-0.5,
					-0.5,
					0.5,
					-0.25,
					-0.1875
				}
			}
		},
		paramtype = "light",
		sounds = {
			dug = {
				name = "default_dug_metal",
				gain = 0.5
			},
			dig = {
				name = "default_dig_metal",
				gain = 0.5
			},
			footstep = {
				name = "default_metal_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_metal",
				gain = 0.5
			}
		},
		drawtype = "nodebox",
		description = "Metal Plant Pot Wet (right-click for lid, sneak + right-click to plant)"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_greybars.png"
		},
		name = "greybars",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "grey bars"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_doomwall1.png"
		},
		name = "doomwall1",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Doom wall 1"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_holes.png"
		},
		name = "holes",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "metal with holes"
	})

klots.register_terrain({
		tiles = {
			{
				name = "scifi_nodes_black_lights.png",
				animation = {
					type = "vertical_frames",
					length = 0.5,
					aspect_h = 16,
					aspect_w = 16
				}
			}
		},
		name = "black_lights",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		sunlight_propagates = false,
		paramtype = "light",
		description = "black wallpanel"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_greytile.png"
		},
		name = "greytile",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "grey tile"
	})

klots.register_terrain({
		node_box = {
			type = "wallmounted"
		},
		light_source = 5,
		drawtype = "signlike",
		sunlight_propagates = true,
		name = "palm_scanner_on",
		tiles = {
			"scifi_nodes_palm_scanner_on.png"
		},
		paramtype2 = "wallmounted",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Palm scanner"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_plant3.png"
		},
		visual_scale = 1.2,
		light_source = 10,
		name = "plant3",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Blue Jelly Plant"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_flower2.png"
		},
		visual_scale = 1.5,
		light_source = 10,
		name = "flower2",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Pink Flower"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_plant7.png"
		},
		visual_scale = 1,
		light_source = 0,
		name = "plant7",
		walkable = false,
		paramtype = "light",
		drawtype = "plantlike",
		description = "Egg weed"
	})

klots.register_terrain({
		tiles = {
			{
				name = "scifi_nodes_lightbox.png",
				animation = {
					type = "vertical_frames",
					length = 2,
					aspect_h = 16,
					aspect_w = 16
				}
			}
		},
		light_source = 5,
		name = "blink",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		sunlight_propagates = false,
		paramtype = "light",
		description = "blinking light"
	})

klots.register_terrain({
		tiles = {
			{
				name = "scifi_nodes_screen2.png",
				animation = {
					type = "vertical_frames",
					length = 0.5,
					aspect_h = 16,
					aspect_w = 16
				}
			}
		},
		light_source = 5,
		name = "screen2",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		sunlight_propagates = false,
		paramtype = "light",
		description = "electronic screen 2"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_grey.png"
		},
		name = "grey",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "grey wall"
	})

klots.register_terrain({
		sunlight_propagates = false,
		visual_scale = 2,
		name = "tower",
		sounds = {
			dug = {
				name = "default_dug_metal",
				gain = 0.5
			},
			dig = {
				name = "default_dig_metal",
				gain = 0.5
			},
			footstep = {
				name = "default_metal_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_metal",
				gain = 0.5
			}
		},
		paramtype = "light",
		tiles = {
			{
				name = "scifi_nodes_tower_anim.png",
				animation = {
					type = "vertical_frames",
					length = 1,
					aspect_h = 32,
					aspect_w = 32
				}
			}
		},
		drawtype = "plantlike",
		description = "Wind tower"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_pplwll.png"
		},
		light_source = 0,
		name = "pplwll",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Purple wall"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_blacktile.png"
		},
		name = "blacktile",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "black tile"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_blackvent.png"
		},
		name = "blackvent",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "black vent"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_monitorwall.png"
		},
		name = "monitorwall",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "Wall monitors"
	})

klots.register_terrain({
		tiles = {
			"scifi_nodes_greenmetal2.png"
		},
		name = "greenmetal2",
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "green metal wall2"
	})
