-- LUALOCALS < ---------------------------------------------------------
local klots, table
    = klots, table
local table_concat
    = table.concat
-- LUALOCALS > ---------------------------------------------------------

if klots.editmode then return end

local text = {
	"The End",
	"... for now ...",
	"",
	"-----=====##########=====-----",
	"",
	"Klots",
	"by Warr1024",
	"",
	". . . . . . . . . . . . . . . . . . . . . .",
	"",
	"Please help out by designing more levels!",
}

klots.register_playerstep(function(player, data)
		if player:get_pos().y < 10000 then return end

		if data.shown then return end
		data.shown = true

		klots.player_control_set(player, "frozen")
		player:get_inventory():set_stack("hand", 1, "")

		for i = 1, #text do
			local lines = {}
			for j = 1, #text do
				lines[#lines + 1] = i == j and text[j] or ""
			end
			player:hud_add({
					hud_elem_type = "text",
					position = {x = 0.5, y = 0.5},
					text = table_concat(lines, "\n"),
					number = 0xffffff,
					z_index = -100
				})
		end
	end)
