-- LUALOCALS < ---------------------------------------------------------
local klots, minetest
    = klots, minetest
-- LUALOCALS > ---------------------------------------------------------

minetest.register_on_joinplayer(function(player)
		player:set_properties({pointable = false})
		player:set_armor_groups({
				immortal = 1,
				fall_damage_add_percent = -100
			})
		local inv = player:get_inventory()
		inv:set_size("main", klots.editmode and 60 or 1)
		if klots.editmode then
			player:set_inventory_formspec("size[10,6]"
				.. "list[current_player;main;0,0;10,6;]")
		else
			player:get_inventory():set_stack("main", 1, "")
		end
	end)

if klots.editmode then
	-- Tap zoom key to rotate inventory through hotbar
	klots.register_playerstep(function(player, data)
			local ctl = player:get_player_control()
			if ctl.zoom then
				data.zoom = true
			elseif data.zoom then
				data.zoom = nil
				local inv = player:get_inventory()
				local list = inv:get_list("main")
				local size = inv:get_size("main")
				for i = 1, size do
					inv:set_stack("main", i, list[(i + 9) % size + 1])
				end
			end
		end)
end
