-- LUALOCALS < ---------------------------------------------------------
local klots, minetest, table
    = klots, minetest, table
local table_concat
    = table.concat
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

if klots.editmode then return end

local crosshair_opacity = 64

local credit_text = {
	"The End",
	"... for now ...",
	"",
	"-----=====##########=====-----",
	"",
	"Klots",
	"by Warr1024",
	"",
	". . . . . . . . . . . . . . . . . . . . . .",
	"",
	"Please help out by designing more levels!",
}

klots.register_playerstep(function(player, data)
		if player:get_pos().y < 10000 then

			if data.credits then
				for i = 1, #data.credits do
					player:hud_remove(data.credits[i])
				end
				data.credits = nil
			end
			if not data.crosshair then
				data.crosshair = player:hud_add({
						hud_elem_type = "image",
						position = {x = 0.5, y = 0.5},
						text = modname .. "_crosshair.png^[opacity:"
						.. crosshair_opacity,
						direction = 0,
						scale = {x = 1, y = 1},
						offset = {x = 0, y = 0},
						z_index = -100
					})
				player:get_inventory():set_stack("hand", 1,
					modname .. ":wieldhand")
			end

		else

			if data.crosshair then
				player:hud_remove(data.crosshair)
				player:get_inventory():set_stack("hand", 1, "")
				data.crosshair = nil
			end

			if not data.credits then
				data.credits = {}
				for i = 1, #credit_text do
					local lines = {}
					for j = 1, #credit_text do
						lines[#lines + 1] = i == j and credit_text[j] or ""
					end
					data.credits[i] = player:hud_add({
							hud_elem_type = "text",
							position = {x = 0.5, y = 0.5},
							text = table_concat(lines, "\n"),
							number = 0xffffff,
							z_index = -100
						})
				end
			end
		end
	end)

minetest.register_on_joinplayer(function(player)
		player:hud_set_flags({crosshair = false})
	end)
