-- LUALOCALS < ---------------------------------------------------------
local klots, minetest, vector
    = klots, minetest, vector
-- LUALOCALS > ---------------------------------------------------------

local leveldata = {}
klots.leveldata = leveldata

-- Populate standard allocation.
local levels = 100
local offset = 8
local marginmin = 32 + 80
local marginmax = 47 + 80
local spacing = 960
local height = 320

do
	local dirs = {
		{x = 1, y = 0, z = 0},
		{x = 1, y = 0, z = 1},
		{x = 0, y = 0, z = 1},
		{x = -1, y = 0, z = 1},
		{x = -1, y = 0, z = 0},
		{x = -1, y = 0, z = -1},
		{x = 0, y = 0, z = -1},
		{x = 1, y = 0, z = -1},
	}
	local queue = {{x = 0, y = 0, z = 0}}
	local seen = {}
	local hash = minetest.hash_node_position
	local idx = 1
	while #leveldata < levels do
		local pos = queue[idx]
		idx = idx + 1
		local key = hash(pos)
		if not seen[key] then
			seen[key] = true
			leveldata[#leveldata + 1] = {
				pos = {
					x = pos.x * spacing + offset,
					y = height + offset - 0.49,
					z = pos.z * spacing + offset,
				},
				minp = {
					x = pos.x * spacing - marginmin,
					y = height - marginmin,
					z = pos.z * spacing - marginmin,
				},
				maxp = {
					x = pos.x * spacing + marginmax,
					y = height + marginmax,
					z = pos.z * spacing + marginmax,
				},
			}
			for i = 1, #dirs do
				queue[#queue + 1] = vector.add(pos, dirs[i])
			end
		end
	end
end

-- Exception(s)
leveldata[1].pos = {x = 7, y = 8.51, z = 1}
leveldata[1].minp.y = -marginmin
leveldata[1].maxp.y = marginmax
