-- LUALOCALS < ---------------------------------------------------------
local klots, minetest, string
    = klots, minetest, string
local string_format
    = string.format
-- LUALOCALS > ---------------------------------------------------------

-- Make the "kill" command reset the current level

minetest.unregister_chatcommand("kill")

minetest.register_chatcommand("kill", {
		description = "Reset the current level",
		func = function(name)
			if not minetest.is_singleplayer() then
				return false, "this command is for singleplayer only"
			end

			local player = minetest.get_player_by_name(name)
			if not player then return false, "invalid player" end

			local ppos = player:get_pos()
			local _, curlv = klots.level_from_pos(ppos)
			if not curlv then return false, "current level not found" end

			klots.player_control_set(player, "frozen")
			klots.flash_screen(player, true)

			local started = minetest.get_us_time()
			local dirty = klots.mapblock_dirty(curlv.minp, curlv.maxp)
			for i = 1, #dirty do
				local p = dirty[i]
				minetest.delete_area(p, p)
			end
			minetest.log("warning", string_format(
					"reset %d mapblocks from %s to %s in %0.3fms",
					#dirty,
					minetest.pos_to_string(curlv.minp),
					minetest.pos_to_string(curlv.maxp),
					(minetest.get_us_time() - started) / 1000))

			local pos = player:get_pos()
			if pos.x >= curlv.minp.x and pos.x <= curlv.maxp.x
			and pos.y >= curlv.minp.y and pos.y <= curlv.maxp.y
			and pos.z >= curlv.minp.z and pos.z <= curlv.maxp.z then
				klots.player_teleport(player, pos, curlv.pos)
			end
		end
	})
