-- LUALOCALS < ---------------------------------------------------------
local klots, math, minetest
    = klots, math, minetest
local math_random
    = math.random
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

local function play(data, pos)
	return minetest.sound_play(modname .. "_air",
		{
			to_player = data.pname,
			pos = pos,
			gain = 0.001,
			pitch = 0.9 + math_random() * 0.2
		})
end

klots.register_playerstep(function(player, data, dtime)
		data.cd = (data.cd or 0) - dtime
		if data.cd > 0 then return end
		data.cd = math_random()

		local pos = player:get_pos()
		pos.y = pos.y + player:get_properties().eye_height
		local target = {
			x = pos.x + math_random() * 8 - 4,
			y = pos.y + math_random() * 8 - 4,
			z = pos.z + math_random() * 8 - 4,
		}

		data.pname = data.pname or player:get_player_name()
		for pt in minetest.raycast(pos, target, false, true) do
			if pt.type == "node" then
				return play(data, pt.intersection_point or pt.above)
			end
		end
		return play(data, target)
	end)
