-- LUALOCALS < ---------------------------------------------------------
local klots, minetest, string, tonumber
    = klots, minetest, string, tonumber
local string_format
    = string.format
-- LUALOCALS > ---------------------------------------------------------

-- Make the "kill" command reset the current level

minetest.unregister_chatcommand("kill")

local function getlv(name)
	local player = minetest.get_player_by_name(name)
	if not player then return false, "invalid player" end

	local ppos = player:get_pos()
	local lv, lvdata = klots.level_from_pos(ppos)
	if not lvdata then return false, "current level not found" end

	return lv, lvdata
end

local function all_players_in(lv)
	local list = minetest.get_connected_players()
	local idx = 1
	return function()
		while true do
			if idx > #list then return end
			local player = list[idx]
			idx = idx + 1
			if klots.level_from_pos(player:get_pos()) == lv then
				return player
			end
		end
	end
end

minetest.register_chatcommand("kill", {
		description = "Reset the current level",
		privs = {interact = true},
		func = function(name)
			local lv, lvdata = getlv(name)
			if not lv then return lv, lvdata end
			if not tonumber(lv) then return false, "invalid level" end

			for player in all_players_in(lv) do
				klots.player_control_set(player, "frozen")
				klots.flash_screen(player, true)
			end

			local started = minetest.get_us_time()
			local dirty = klots.mapblock_dirty(lvdata.minp, lvdata.maxp)
			for i = 1, #dirty do
				local p = dirty[i]
				minetest.delete_area(p, p)
			end
			minetest.log("warning", string_format(
					"reset %d mapblocks from %s to %s in %0.3fms",
					#dirty,
					minetest.pos_to_string(lvdata.minp),
					minetest.pos_to_string(lvdata.maxp),
					(minetest.get_us_time() - started) / 1000))

			for player in all_players_in(lv) do
				klots.player_teleport(player, player:get_pos(), lvdata.pos)
			end
		end
	})
