-- LUALOCALS < ---------------------------------------------------------
local error, klots, minetest, string
    = error, klots, minetest, string
local string_format
    = string.format
-- LUALOCALS > ---------------------------------------------------------

local function all_players_in(lv)
	local list = minetest.get_connected_players()
	local idx = 1
	return function()
		while true do
			if idx > #list then return end
			local player = list[idx]
			idx = idx + 1
			if klots.level_from_pos(player:get_pos()) == lv then
				return player
			end
		end
	end
end

function klots.level_reset(lv)
	local lvdata = klots.leveldata[lv] or error("invalid level")

	for player in all_players_in(lv) do
		klots.player_control_set(player, "frozen")
		klots.flash_screen(player, true)
	end

	local started = minetest.get_us_time()
	local dirty = klots.mapblock_dirty(lvdata.minp, lvdata.maxp)
	for i = 1, #dirty do
		local p = dirty[i]
		minetest.delete_area(p, p)
	end
	minetest.log("warning", string_format(
			"reset %d mapblocks from %s to %s in %0.3fms",
			#dirty,
			minetest.pos_to_string(lvdata.minp),
			minetest.pos_to_string(lvdata.maxp),
			(minetest.get_us_time() - started) / 1000))

	for player in all_players_in(lv) do
		klots.player_teleport(player, player:get_pos(), lvdata.pos)
	end
end
