# Klots

Sliding block puzzles in an alien environment

## How to Play

Instructions should not be necessary.  The game has very simple controls.  Explore and learn the mechanics as you go.

Singleplayer or cooperative team play over LAN is recommended.  General internet multiplayer is not currently recommended.

If you believe you have become softlocked, then:

- `/kill` should emergency reset the current level.
- Accidental softlocks _may_ be considered bugs, especially in earlier levels; please report them.

You can turn off music with `/set -n klots_music_volume 0` (or set it to any other amount, default 1.0)

## Editing and Level Design

To edit the map, create a special "editing" world:

- Create a new klots world.
- Add a file named `klots_edit` in the root of the world dir.
- Install the [modgen](/packages/BuckarooBanzay/modgen/) mod.
- Enter the editing world and grant yourself the necessary permissions.
- You can use the `/lv` chat command to teleport to a level.  The place you end up at is exactly where the player will start in the level.
- Teleport to each existing level and use `/export` or `/export_here` to register the area with modgen and export it.
	- Registering and exporting the existing map areas is necessary to include them in the manifest.
	- You can use `/autosave on` to enable autosaving for future edits in registered areas.

### Editing Mode Controls

- Right-click a node with an empty hand to pick up a copy of the node.
- To free up inventory space, you can simply drop items; they are destroyed.  Use `/clearinv` to do the whole thing.
- There is no "creative mode" menu (yet).  Use [szutil_givemenu](/packages/Warr1024/szutilpack/) to add the `/gm` command with a more convenient search interface.
- If you right-click to place a node without pointing at another node, it will place that node at the extent of your reach (4 nodes away) in mid-air; use this to start mid-air structures.
- Tapping the zoom key in edit mode (ignore the message) inventory rows through your hotbar, for juggling more than 10 building materials at a time.

### Level Management

- The total number of levels is stored in a constant in `mods/klots_api/api_leveldata.lua`; increase it to add more levels.
- By default, each end-of-level teleporter takes the player to the next level, or to the end credits on the last level.  Multiple exits in a single level will take the player to the same place (alternate destinations are not _yet_ supported).
- Overrides can be added at the bottom of `mods/klots_api/api_leveldata.lua`, but should be used _sparingly_.

### Special Nodes

- The "Invisible Terrain End" node is only to be used in "terrestrial" areas (i.e. level 1).
	- It's what the "ground" is made out of via flat mapgen.
	- It teleports the player to spawn if stepped over.
- The "Invisible Collision Hull" node just blocks the player.
	- It's often used behind level-end teleporters to prevent overshoot.
	- Avoid using it for windows instead glass-like nodes due to player confusion.
- The "Camera Focus" node sets the initial direction the player is looking when starting a level.
	- There should be only 1 in each level.
	- Place it reasonably near the player (less than a mapblock away)
- The "Level End Portal" node teleports the player to the next level (or the end credits on the last level).
- Some nodes may have smaller special behaviors:
	- Fire and lava repel the player.
	- Fire and water emit ambient sounds.
	- Most nodes other than air will block the movement of klots.

### Install Map Changes into the Game

- Exit the editing world after all exports have quiesced.
- From the `modgen_mod_export` dir inside the world dir, copy the `manifest.json` file and `map` dir and all its contents over the corresponding items in `mods/klots_mapgen` within the game dir.
- To play test, create a new world *without* the klots_edit file.

### Submitting Levels for Official Inclusion

- Acceptable formats:
	- [worldedit](/packages/sfan5/worldedit/) format is good for the general case.
		- Please provide the exact coordinates at which it should be imported.
	- Submitting your `manifest.json` and `map/chunk_*.bin` files is also acceptable.
	- Pull/Merge Requests can also be accepted.
		- Please "rebase" your changes against latest master, because chunk*.bin files cannot be automatically merged.  This probably means saving your changes with worldedit, resetting to latest master, and then reimporting them back in place.
- Levels must fit somewhere in the progression, i.e. use existing skills learned in previous levels, and add some new challenge/insight.
- Levels must also fit the general theme and atmosphere of the game, and if possible should try to build on the narrative via environmental storytelling.
- Updates/improvements/fixes for existing levels are also welcome.

## Credits

- klots_music
	- klots_music_flute.ogg
		- Wood_Flutes (CC-BY 3.0)
		- https://freesound.org/people/Wood_Flutes/sounds/264942/
- klots_player
	- klots_player_model.b3d
		- LoneWolfHT and MisterE (MIT)
		- From NodeCore
	- klots_player_hand.obj
		- LoneWolfHT (MIT)
		- From NodeCore
	- klots_player_skin.png
		- WintersKnight94 (MIT)
		- From NodeCore, heavily modified
- klots_skybox
	- space skybox textures
		- Westbeam (CC0 / WTFPL)
		- https://opengameart.org/content/space-skyboxes-1
	- land skybox textures
		- Emil Persson (CC-BY 3.0)
		- https://opengameart.org/content/mountain-skyboxes
- klots_terrain_mtg
	- all textures by various artists:
		- BlockMen (CC BY-SA 3.0)
		- Cisoun (CC-BY-SA 3.0)
		- Extex101 (CC BY-SA 3.0)
		- Gambit (CC BY-SA 3.0)
		- Krock (CC0 1.0)
		- MasterGollum (CC BY 3.0)
		- Mossmanikin (CC BY-SA 3.0)
		- Muadtralk (CC BY-SA 3.0)
		- Neuromancer (CC BY-SA 3.0)
		- npx (CC BY-SA 3.0)
		- paramat (CC BY-SA 3.0)
		- PilzAdam (CC BY-SA 3.0)
		- random-geek (CC BY-SA 3.0)
		- RealBadAngel (CC-BY-SA 3.0)
		- RHRhino (CC BY-SA 3.0)
		- yyt16384 (CC BY-SA 3.0)
		- Shara RedCat (CC BY-SA 3.0)
		- sofar (CC BY-SA 3.0)
		- Splizard (CC BY-SA 3.0)
		- tobyplowy (CC BY-SA 3.0)
		- TumeniNodes (CC-BY-SA 3.0)
		- xyz (CC BY-SA 3.0)
		- From minetest_game
			- default
			- farming
			- fire
			- flowers
			- xpanes
	- all sounds by various artists:
		- AGFX (CC BY 3.0)
		- Erdie (CC BY 3.0)
		- Iwan Gabovitch - qubodup (CC0)
		- Mito551 (CC BY-SA 3.0)
		- Ogrebane (CC0 1.0)
		- Sheyvan (CC0 1.0)
		- worthahep88 (CC0 1.0)
		- yadronoff (CC-BY 3.0)
		- From minetest_game default
- klots_terrain_scifi
	- all textures, and nodebox designs
		- DOOMED (CC-BY-SA 3.0 UNPORTED)
		- From scifi_nodes mod
- klots_mapgen
	- modgen_*.lua
		- BuckarooBanzay (MIT)
		- From the modgen export mod