-- LUALOCALS < ---------------------------------------------------------
local klots, math, minetest, pairs, table
    = klots, math, minetest, pairs, table
local math_ceil, table_sort
    = math.ceil, table.sort
-- LUALOCALS > ---------------------------------------------------------

local creativeinv
if klots.editmode then
	klots.register_item_modifier(function(name, def)
			local desc = def.description or ""
			if desc ~= "" then desc = desc .. "\n" end
			def.description = desc .. name
		end)
	minetest.register_on_mods_loaded(function()
			local allnames = {}
			for k, v in pairs(minetest.registered_nodes) do
				local nic = v.groups.not_in_creative_inventory
				if nic and nic > 0 then
					allnames[#allnames + 1] = k
				end
			end
			table_sort(allnames)
			creativeinv = minetest.create_detached_inventory("creative", {
					allow_take = function() return -1 end
				})
			creativeinv:set_size("main", #allnames)
			for i = 1, #allnames do
				creativeinv:set_stack("main", i, allnames[i])
			end
		end)
end

minetest.register_on_joinplayer(function(player)
		player:set_properties({pointable = false})
		player:set_armor_groups({
				immortal = 1,
				fall_damage_add_percent = -100
			})
		local inv = player:get_inventory()
		inv:set_size("main", klots.editmode and 20 or 1)
		if klots.editmode then
			local ch = math_ceil(creativeinv:get_size("main") / 9)
			player:set_inventory_formspec(
				"formspec_version[6]"
				.. "size[12.75,9.75]"
				.. "scroll_container[0.25,0.25;11.25,6;scroll;vertical;"
				.. (((ch - 5) * 1.25 - 0.25) / 1000) .. "]"
				.. "list[detached:creative;main;0,0;10," .. ch .. "]"
				.. "scroll_container_end[]"
				.. "scrollbar[11.5,0.25;0.5,6;vertical;scroll;0]"
				.. "list[current_player;main;0.25,7;10,2;]")
		else
			player:get_inventory():set_stack("main", 1, "")
		end
	end)

if klots.editmode then
	-- Tap zoom key to rotate inventory through hotbar
	klots.register_playerstep(function(player, data)
			local ctl = player:get_player_control()
			if ctl.zoom then
				data.zoom = true
			elseif data.zoom then
				data.zoom = nil
				local inv = player:get_inventory()
				local list = inv:get_list("main")
				local size = inv:get_size("main")
				for i = 1, size do
					inv:set_stack("main", i, list[(i + 9) % size + 1])
				end
			end
		end)
end
