-- LUALOCALS < ---------------------------------------------------------
local error, klots, minetest
    = error, klots, minetest
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

minetest.register_node(modname .. ":reset_button", {
		description = "Reset Button",
		tiles = {"scifi_nodes_stripes.png^" .. modname .. "_reset_button.png"},
		on_actuate = function(pos)
			klots.actuate_cooldown(pos, 2)
			return klots.level_reset(pos)
		end
	})

local function particles(pos)
	minetest.add_particlespawner({
			time = 0.01,
			amount = 50,
			collisiondetection = true,
			exptime = {min = 0.5, max = 2},
			size = {
				min = 0.5,
				max = 2,
				bias = 1
			},
			node = {name = "klots_terrain_mtg:default_glass"},
			pos = {
				min = {x = pos.x - 0.5, y = pos.y - 0.5, z = pos.z - 0.5},
				max = {x = pos.x + 0.5, y = pos.y + 0.5, z = pos.z + 0.5}
			},
			vel = {
				min = {x = -0.5, y = -0.5, z = -0.5},
				max = {x = 0.5, y = 0.5, z = 0.5},
			},
		})
end

local glass = minetest.registered_nodes["klots_terrain_mtg:default_glass"]
or error("mtg glass not found")
local crackpref = "^(" .. modname .. "_reset_crack.png^[verticalframe:2:"
local function breakto(name)
	return function(pos)
		particles(pos)
		klots.actuate_cooldown(pos, 1)
		klots.node_sound(pos, "dug", "dig")
		return minetest.set_node(pos, {name = name})
	end
end
local function nobf(name)
	return {{
			name = name,
			backface_culling = false
	}}
end
minetest.register_node(modname .. ":reset_cover_1", {
		description = "Reset Cover",
		drawtype = "glasslike_framed",
		tiles = {glass.tiles[1]},
		sounds = glass.sounds,
		on_actuate = breakto(modname .. ":reset_cover_2")
	})
minetest.register_node(modname .. ":reset_cover_2", {
		description = "Reset Cover - Small Crack",
		drawtype = "glasslike_framed",
		tiles = nobf(glass.tiles[1] .. crackpref .. "0)"),
		sounds = glass.sounds,
		on_actuate = breakto(modname .. ":reset_cover_3")
	})
minetest.register_node(modname .. ":reset_cover_3", {
		description = "Reset Cover - Large Crack",
		drawtype = "glasslike_framed",
		tiles = nobf(glass.tiles[1] .. crackpref .. "1)"),
		sounds = glass.sounds,
		on_actuate = breakto(modname .. ":reset_cover_4")
	})
minetest.register_node(modname .. ":reset_cover_4", {
		description = "Reset Cover - Broken",
		drawtype = "glasslike_framed",
		pointable = false,
		tiles = nobf(modname .. "_reset_broken.png")
	})
