-- LUALOCALS < ---------------------------------------------------------
local error, klots, minetest, pairs
    = error, klots, minetest, pairs
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

minetest.register_node(modname .. ":reset_button", {
		description = "Reset Button",
		tiles = {"scifi_nodes_stripes.png^" .. modname .. "_reset_button.png"},
		paramtype = "light",
		light_souce = 5,
		on_actuate = function(pos)
			klots.actuate_cooldown(pos, 2)
			return klots.level_reset(pos)
		end
	})

local glass = minetest.registered_nodes["klots_terrain_mtg:default_glass"]
or error("mtg glass not found")

local function particles(pos, qty)
	return minetest.add_particlespawner({
			time = 0.1,
			amount = qty or 25,
			collisiondetection = true,
			exptime = {min = 0.5, max = 4, bias = 1},
			texture = "^[combine:1x1^[noalpha^[colorize:#ffffff:255",
			size = {min = 0.25, max = 1, bias = 1
			},
			pos = {
				min = {x = pos.x - 0.5, y = pos.y - 0.5, z = pos.z - 0.5},
				max = {x = pos.x + 0.5, y = pos.y + 0.5, z = pos.z + 0.5}
			},
			vel = {
				min = {x = -0.5, y = -0.5, z = -0.5},
				max = {x = 0.5, y = 0.5, z = 0.5},
			},
		})
end

local function regmolly(suff, def, breakto, shards)
	for k, v in pairs({
			description = "Reset Button Molly-Guard",
			drawtype = "glasslike_framed",
			tiles = {glass.tiles[1]},
			sounds = glass.sounds,
			paramtype = "light",
			sunlight_propagates = true,
			on_actuate = function(pos)
				particles(pos, shards)
				klots.actuate_cooldown(pos, 1)
				klots.node_sound(pos, "dug", "dig")
				return minetest.set_node(pos, {name = breakto})
			end
		}) do
		if def[k] == nil then
			def[k] = v
		end
	end
	return minetest.register_node(modname .. ":reset_cover_" .. suff, def)
end

local crackpref = "^(" .. modname .. "_reset_crack.png^[verticalframe:2:"
local function nobf(name)
	return {{
			name = name,
			backface_culling = false
	}}
end

regmolly(1, {}, modname .. ":reset_cover_2")
regmolly(2, {
		groups = {not_in_creative_inventory = 1},
		tiles = nobf(glass.tiles[1] .. crackpref .. "0)")
	}, modname .. ":reset_cover_3")
regmolly(3, {
		groups = {not_in_creative_inventory = 1},
		tiles = nobf(glass.tiles[1] .. crackpref .. "1)")
	}, modname .. ":reset_cover_4", 100)
regmolly(4, {
		groups = {not_in_creative_inventory = 1},
		pointable = false,
		tiles = nobf(modname .. "_reset_broken.png"),
		on_actuate = false,
		on_construct = function(pos)
			pos = minetest.find_node_near(pos, 1, modname .. ":reset_button")
			if pos then klots.actuate_cooldown(pos, 1) end
		end
	})
