-- LUALOCALS < ---------------------------------------------------------
local klots
    = klots
-- LUALOCALS > ---------------------------------------------------------

klots.register_terrain({
		tiles = {
			"default_gravel.png"
		},
		sounds = {
			dug = {
				name = "default_gravel_dug",
				gain = 1
			},
			dig = {
				name = "default_gravel_dig",
				gain = 0.35
			},
			footstep = {
				name = "default_gravel_footstep",
				gain = 0.25
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		name = "default_gravel",
		description = "\27(T@default)Gravel\27E"
	})

klots.register_terrain({
		tiles = {
			"default_rainforest_litter.png",
			"default_dirt.png",
			{
				name = "default_dirt.png^default_rainforest_litter_side.png",
				tileable_vertical = false
			}
		},
		sounds = {
			dug = {
				name = "default_dirt_footstep",
				gain = 1
			},
			dig = {
				name = "default_dig_crumbly",
				gain = 0.4
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.4
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		name = "default_dirt_with_rainforest_litter",
		description = "\27(T@default)Dirt with Rainforest Litter\27E"
	})

klots.register_terrain({
		tiles = {
			"default_pine_needles.png"
		},
		name = "default_pine_needles",
		drawtype = "allfaces_optional",
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		paramtype = "light",
		description = "\27(T@default)Pine Needles\27E"
	})

klots.register_terrain({
		ouch = true,
		climbable = true,
		tiles = {
			{
				backface_culling = false,
				name = "default_lava_source_animated.png",
				animation = {
					type = "vertical_frames",
					length = 3,
					aspect_h = 16,
					aspect_w = 16
				}
			},
			{
				backface_culling = true,
				name = "default_lava_source_animated.png",
				animation = {
					type = "vertical_frames",
					length = 3,
					aspect_h = 16,
					aspect_w = 16
				}
			}
		},
		walkable = false,
		light_source = 13,
		name = "default_lava_source",
		paramtype = "light",
		drawtype = "liquid",
		description = "\27(T@default)Lava Source\27E"
	})

klots.register_terrain({
		ouch = true,
		tiles = {
			{
				name = "fire_basic_flame_animated.png",
				animation = {
					type = "vertical_frames",
					length = 1,
					aspect_w = 16,
					aspect_h = 16
				}
			}
		},
		sounds = {
			ambiance = {
				name = "klots_terrain_mtg_flame",
				gain = 0.1
			},
		},
		groups = {ambiance = 100},
		walkable = false,
		light_source = 13,
		name = "fire_permanent_flame",
		sunlight_propagates = true,
		paramtype = "light",
		drawtype = "firelike",
		description = "\27(T@fire)Permanent Fire\27E"
	})

klots.register_terrain({
		tiles = {
			"flowers_mushroom_red.png"
		},
		walkable = false,
		name = "flowers_mushroom_red",
		sunlight_propagates = true,
		paramtype = "light",
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		drawtype = "plantlike",
		description = "\27(T@flowers)Red Mushroom\27E"
	})

klots.register_terrain({
		tiles = {
			"flowers_dandelion_yellow.png"
		},
		walkable = false,
		name = "flowers_dandelion_yellow",
		paramtype = "light",
		sunlight_propagates = true,
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		drawtype = "plantlike",
		description = "\27(T@flowers)Yellow Dandelion\27E"
	})

klots.register_terrain({
		tiles = {
			"default_junglegrass.png"
		},
		visual_scale = 1.69,
		drawtype = "plantlike",
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		walkable = false,
		name = "default_junglegrass",
		sunlight_propagates = true,
		paramtype = "light",
		description = "\27(T@default)Jungle Grass\27E"
	})

klots.register_terrain({
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		walkable = false,
		name = "default_pine_sapling",
		sunlight_propagates = true,
		tiles = {
			"default_pine_sapling.png"
		},
		drawtype = "plantlike",
		paramtype = "light",
		description = "\27(T@default)Pine Tree Sapling\27E"
	})

klots.register_terrain({
		tiles = {
			"default_bush_stem.png"
		},
		visual_scale = 1.41,
		name = "default_bush_stem",
		paramtype = "light",
		sunlight_propagates = true,
		sounds = {
			dug = {
				name = "default_wood_footstep",
				gain = 1
			},
			dig = {
				name = "default_dig_choppy",
				gain = 0.4
			},
			footstep = {
				name = "default_wood_footstep",
				gain = 0.15
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		drawtype = "plantlike",
		description = "\27(T@default)Bush Stem\27E"
	})

klots.register_terrain({
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.03125,
					0.5,
					0.5,
					0.03125
				}
			}
		},
		use_texture_alpha = "clip",
		drawtype = "nodebox",
		sunlight_propagates = true,
		name = "xpanes_bar_flat",
		tiles = {
			"xpanes_bar_top.png",
			"xpanes_bar_top.png",
			"xpanes_bar_top.png",
			"xpanes_bar_top.png",
			"xpanes_bar.png",
			"xpanes_bar.png"
		},
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_dug_metal",
				gain = 0.5
			},
			dig = {
				name = "default_dig_metal",
				gain = 0.5
			},
			footstep = {
				name = "default_metal_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_metal",
				gain = 0.5
			}
		},
		paramtype = "light",
		description = "\27(T@xpanes)Steel Bars\27E"
	})

klots.register_terrain({
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		walkable = false,
		name = "default_fern_1",
		sunlight_propagates = true,
		tiles = {
			"default_fern_1.png"
		},
		drawtype = "plantlike",
		paramtype = "light",
		description = "\27(T@default)Fern\27E"
	})

klots.register_terrain({
		tiles = {
			"default_obsidian_glass.png",
			"default_obsidian_glass_detail.png"
		},
		name = "default_obsidian_glass",
		use_texture_alpha = "clip",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		sunlight_propagates = true,
		drawtype = "glasslike_framed_optional",
		description = "\27(T@default)Obsidian Glass\27E"
	})

klots.register_terrain({
		tiles = {
			"default_grass.png",
			"default_dirt.png",
			{
				name = "default_dirt.png^default_grass_side.png",
				tileable_vertical = false
			}
		},
		sounds = {
			dug = {
				name = "default_dirt_footstep",
				gain = 1
			},
			dig = {
				name = "default_dig_crumbly",
				gain = 0.4
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.25
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		name = "default_dirt_with_grass",
		description = "\27(T@default)Dirt with Grass\27E"
	})

klots.register_terrain({
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.03125,
					0.5,
					0.5,
					0.03125
				}
			}
		},
		use_texture_alpha = "clip",
		drawtype = "nodebox",
		sunlight_propagates = true,
		name = "xpanes_obsidian_pane_flat",
		tiles = {
			"xpanes_edge_obsidian.png",
			"xpanes_edge_obsidian.png",
			"xpanes_edge_obsidian.png",
			"xpanes_edge_obsidian.png",
			"default_obsidian_glass.png",
			"default_obsidian_glass.png"
		},
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "\27(T@xpanes)Obsidian Glass Pane\27E"
	})

klots.register_terrain({
		tiles = {
			"default_pine_tree_top.png",
			"default_pine_tree_top.png",
			"default_pine_tree.png"
		},
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_wood_footstep",
				gain = 1
			},
			dig = {
				name = "default_dig_choppy",
				gain = 0.4
			},
			footstep = {
				name = "default_wood_footstep",
				gain = 0.15
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "default_pine_tree",
		description = "\27(T@default)Pine Tree\27E"
	})

klots.register_terrain({
		tiles = {
			"farming_straw.png"
		},
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		name = "farming_straw",
		description = "\27(T@farming)Straw\27E"
	})

klots.register_terrain({
		tiles = {
			"flowers_rose.png"
		},
		walkable = false,
		name = "flowers_rose",
		paramtype = "light",
		sunlight_propagates = true,
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		drawtype = "plantlike",
		description = "\27(T@flowers)Red Rose\27E"
	})

klots.register_terrain({
		tiles = {
			"default_blueberry_bush_leaves.png"
		},
		name = "default_blueberry_bush_leaves",
		drawtype = "allfaces_optional",
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		paramtype = "light",
		description = "\27(T@default)Blueberry Bush Leaves\27E"
	})

klots.register_terrain({
		tiles = {
			{
				name = "fireflies_firefly_animated.png",
				animation = {
					type = "vertical_frames",
					length = 1.5,
					aspect_h = 16,
					aspect_w = 16
				}
			}
		},
		walkable = false,
		light_source = 6,
		name = "fireflies_firefly",
		sunlight_propagates = true,
		paramtype = "light",
		drawtype = "plantlike",
		description = "\27(T@fireflies)Firefly\27E"
	})

klots.register_terrain({
		tiles = {
			"default_dirt.png"
		},
		sounds = {
			dug = {
				name = "default_dirt_footstep",
				gain = 1
			},
			dig = {
				name = "default_dig_crumbly",
				gain = 0.4
			},
			footstep = {
				name = "default_dirt_footstep",
				gain = 0.25
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		name = "default_dirt",
		description = "\27(T@default)Dirt\27E"
	})

klots.register_terrain({
		tiles = {
			"flowers_viola.png"
		},
		walkable = false,
		name = "flowers_viola",
		paramtype = "light",
		sunlight_propagates = true,
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		drawtype = "plantlike",
		description = "\27(T@flowers)Viola\27E"
	})

klots.register_terrain({
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		walkable = false,
		name = "farming_cotton_wild",
		sunlight_propagates = true,
		tiles = {
			"farming_cotton_wild.png"
		},
		drawtype = "plantlike",
		paramtype = "light",
		description = "\27(T@farming)Wild Cotton\27E"
	})

klots.register_terrain({
		tiles = {
			"default_tree_top.png",
			"default_tree_top.png",
			"default_tree.png"
		},
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_wood_footstep",
				gain = 1
			},
			dig = {
				name = "default_dig_choppy",
				gain = 0.4
			},
			footstep = {
				name = "default_wood_footstep",
				gain = 0.15
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "default_tree",
		description = "\27(T@default)Apple Tree\27E"
	})

klots.register_terrain({
		tiles = {
			"default_coniferous_litter.png",
			"default_dirt.png",
			{
				name = "default_dirt.png^default_coniferous_litter_side.png",
				tileable_vertical = false
			}
		},
		sounds = {
			dug = {
				name = "default_dirt_footstep",
				gain = 1
			},
			dig = {
				name = "default_dig_crumbly",
				gain = 0.4
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.4
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		name = "default_dirt_with_coniferous_litter",
		description = "\27(T@default)Dirt with Coniferous Litter\27E"
	})

klots.register_terrain({
		node_box = {
			type = "fixed",
			fixed = {
				{
					-0.5,
					-0.5,
					-0.03125,
					0.5,
					0.5,
					0.03125
				}
			}
		},
		use_texture_alpha = "clip",
		drawtype = "nodebox",
		sunlight_propagates = true,
		name = "xpanes_pane_flat",
		tiles = {
			"xpanes_edge.png",
			"xpanes_edge.png",
			"xpanes_edge.png",
			"xpanes_edge.png",
			"default_glass.png",
			"default_glass.png"
		},
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		paramtype = "light",
		description = "\27(T@xpanes)Glass Pane\27E"
	})

klots.register_terrain({
		tiles = {
			"flowers_dandelion_white.png"
		},
		walkable = false,
		name = "flowers_dandelion_white",
		paramtype = "light",
		sunlight_propagates = true,
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		drawtype = "plantlike",
		description = "\27(T@flowers)White Dandelion\27E"
	})

klots.register_terrain({
		tiles = {
			"flowers_mushroom_brown.png"
		},
		walkable = false,
		name = "flowers_mushroom_brown",
		sunlight_propagates = true,
		paramtype = "light",
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		drawtype = "plantlike",
		description = "\27(T@flowers)Brown Mushroom\27E"
	})

klots.register_terrain({
		climbable = true,
		sounds = {
			dug = {
				name = "default_dug_node",
				gain = 0.25
			},
			footstep = {
				name = "default_water_footstep",
				gain = 0.2
			},
			ambiance = {
				name = "default_water_footstep",
				gain = 0.05
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		groups = {ambiance = 2},
		walkable = false,
		use_texture_alpha = "blend",
		name = "default_water_source",
		tiles = {
			{
				backface_culling = false,
				name = "default_water_source_animated.png",
				animation = {
					type = "vertical_frames",
					length = 2,
					aspect_h = 16,
					aspect_w = 16
				}
			},
			{
				backface_culling = true,
				name = "default_water_source_animated.png",
				animation = {
					type = "vertical_frames",
					length = 2,
					aspect_h = 16,
					aspect_w = 16
				}
			}
		},
		drawtype = "liquid",
		paramtype = "light",
		description = "\27(T@default)Water Source\27E"
	})

klots.register_terrain({
		tiles = {
			"default_blueberry_bush_leaves.png^default_blueberry_overlay.png"
		},
		name = "default_blueberry_bush_leaves_with_berries",
		drawtype = "allfaces_optional",
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		paramtype = "light",
		description = "\27(T@default)Blueberry Bush Leaves with Berries\27E"
	})

klots.register_terrain({
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		walkable = false,
		name = "default_grass_1",
		sunlight_propagates = true,
		tiles = {
			"default_grass_1.png"
		},
		drawtype = "plantlike",
		paramtype = "light",
		description = "\27(T@default)Grass\27E"
	})

klots.register_terrain({
		tiles = {
			"default_stone.png"
		},
		sounds = {
			dug = {
				name = "default_hard_footstep",
				gain = 1
			},
			footstep = {
				name = "default_hard_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "default_stone",
		description = "\27(T@default)Stone\27E"
	})

klots.register_terrain({
		tiles = {
			"flowers_chrysanthemum_green.png"
		},
		walkable = false,
		name = "flowers_chrysanthemum_green",
		paramtype = "light",
		sunlight_propagates = true,
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		drawtype = "plantlike",
		description = "\27(T@flowers)Green Chrysanthemum\27E"
	})

klots.register_terrain({
		tiles = {
			"flowers_geranium.png"
		},
		walkable = false,
		name = "flowers_geranium",
		paramtype = "light",
		sunlight_propagates = true,
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		drawtype = "plantlike",
		description = "\27(T@flowers)Blue Geranium\27E"
	})

klots.register_terrain({
		tiles = {
			"flowers_tulip_black.png"
		},
		walkable = false,
		name = "flowers_tulip_black",
		paramtype = "light",
		sunlight_propagates = true,
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		drawtype = "plantlike",
		description = "\27(T@flowers)Black Tulip\27E"
	})

klots.register_terrain({
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.25
			},
			dig = {
				name = "default_dig_snappy",
				gain = 0.2
			},
			footstep = {
				name = "default_sand_footstep",
				gain = 0.05
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		name = "default_sand",
		tiles = {
			"default_sand.png"
		},
		paramtype = "light",
		description = "\27(T@default)Sand\27E"
	})

klots.register_terrain({
		tiles = {
			"default_clay.png"
		},
		sounds = {
			dug = {
				name = "default_dirt_footstep",
				gain = 1
			},
			dig = {
				name = "default_dig_crumbly",
				gain = 0.4
			},
			footstep = {
				name = "default_dirt_footstep",
				gain = 0.25
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		name = "default_clay",
		description = "\27(T@default)Clay\27E"
	})

klots.register_terrain({
		tiles = {
			"flowers_tulip.png"
		},
		walkable = false,
		name = "flowers_tulip",
		paramtype = "light",
		sunlight_propagates = true,
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		drawtype = "plantlike",
		description = "\27(T@flowers)Orange Tulip\27E"
	})

klots.register_terrain({
		tiles = {
			"default_mossycobble.png"
		},
		sounds = {
			dug = {
				name = "default_hard_footstep",
				gain = 1
			},
			footstep = {
				name = "default_hard_footstep",
				gain = 0.2
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		name = "default_mossycobble",
		description = "\27(T@default)Mossy Cobblestone\27E"
	})

klots.register_terrain({
		climbable = true,
		sounds = {
			dug = {
				name = "default_dug_node",
				gain = 0.25
			},
			footstep = {
				name = "default_water_footstep",
				gain = 0.2
			},
			ambiance = {
				name = "default_water_footstep",
				gain = 0.02,
				max_hear_distance = 16
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		groups = {ambiance = 2},
		walkable = false,
		use_texture_alpha = "blend",
		name = "default_river_water_source",
		tiles = {
			{
				backface_culling = false,
				name = "default_river_water_source_animated.png",
				animation = {
					type = "vertical_frames",
					length = 2,
					aspect_h = 16,
					aspect_w = 16
				}
			},
			{
				backface_culling = true,
				name = "default_river_water_source_animated.png",
				animation = {
					type = "vertical_frames",
					length = 2,
					aspect_h = 16,
					aspect_w = 16
				}
			}
		},
		drawtype = "liquid",
		paramtype = "light",
		description = "\27(T@default)River Water Source\27E"
	})

klots.register_terrain({
		tiles = {
			"default_leaves_simple.png"
		},
		name = "default_bush_leaves",
		drawtype = "allfaces_optional",
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		paramtype = "light",
		description = "\27(T@default)Bush Leaves\27E"
	})

klots.register_terrain({
		node_box = {
			type = "fixed",
			fixed = {
				-0.5,
				-0.484375,
				-0.5,
				0.5,
				-0.46875,
				0.5
			}
		},
		use_texture_alpha = "clip",
		drawtype = "nodebox",
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		walkable = false,
		name = "flowers_waterlily",
		paramtype2 = "facedir",
		tiles = {
			"flowers_waterlily.png",
			"flowers_waterlily_bottom.png"
		},
		paramtype = "light",
		description = "\27(T@flowers)Waterlily\27E"
	})

klots.register_terrain({
		tiles = {
			"default_glass.png",
			"default_glass_detail.png"
		},
		name = "default_glass",
		use_texture_alpha = "clip",
		sunlight_propagates = true,
		paramtype = "light",
		sounds = {
			dug = {
				name = "default_break_glass",
				gain = 1
			},
			dig = {
				name = "default_glass_footstep",
				gain = 0.5
			},
			footstep = {
				name = "default_glass_footstep",
				gain = 0.3
			},
			place = {
				name = "default_place_node_hard",
				gain = 1
			}
		},
		drawtype = "glasslike_framed_optional",
		description = "\27(T@default)Glass\27E"
	})

klots.register_terrain({
		sounds = {
			dug = {
				name = "default_grass_footstep",
				gain = 0.7
			},
			footstep = {
				name = "default_grass_footstep",
				gain = 0.45
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		walkable = false,
		name = "default_sapling",
		sunlight_propagates = true,
		tiles = {
			"default_sapling.png"
		},
		drawtype = "plantlike",
		paramtype = "light",
		description = "\27(T@default)Apple Tree Sapling\27E"
	})

klots.register_terrain({
		tiles = {
			"bones_top.png^[transform2",
			"bones_bottom.png",
			"bones_side.png",
			"bones_side.png",
			"bones_rear.png",
			"bones_front.png"
		},
		paramtype2 = "facedir",
		sounds = {
			dug = {
				name = "default_gravel_dug",
				gain = 1
			},
			dig = {
				name = "default_gravel_dig",
				gain = 0.35
			},
			footstep = {
				name = "default_gravel_footstep",
				gain = 0.25
			},
			place = {
				name = "default_place_node",
				gain = 1
			}
		},
		name = "bones_bones",
		description = "\27(T@bones)Bones\27E"
	})
