-- AUTOMATICALLY GENERATED by <https://gitlab.com/szest/defripper>

local reg = ...

local scifi_nodes_screen_tiles_1_animation = {aspect_h = 16,
	aspect_w = 16,
	length = 0.5,
	type = "vertical_frames"}

local scifi_nodes_cover_sounds = {dig = {gain = 0.4, name = "default_dig_choppy"},
	dug = {gain = 1, name = "default_wood_footstep"},
	footstep = {gain = 0.15, name = "default_wood_footstep"},
	place = {gain = 1, name = "default_place_node_hard"}}

local scifi_nodes_box_sounds = {dig = {gain = 0.5, name = "default_dig_metal"},
	dug = {gain = 0.5, name = "default_dug_metal"},
	footstep = {gain = 0.2, name = "default_metal_footstep"},
	place = {gain = 0.5, name = "default_place_node_metal"}}

local scifi_nodes_fan_sounds = {dig = {gain = 0.5, name = "default_glass_footstep"},
	dug = {gain = 1, name = "default_break_glass"},
	footstep = {gain = 0.3, name = "default_glass_footstep"},
	place = {gain = 1, name = "default_place_node_hard"}}

local scifi_nodes_windowstraight_node_box = {fixed = {{-0.3125, -0.5, -0.5, 0.3125, -0.25, 0.5},
		{-0.0625, -0.5, -0.5, 0.0625, 0.5, 0.5}},
	type = "fixed"}

local scifi_nodes_windowcorner_node_box = {fixed = {{-0.3125, -0.5, -0.5, 0.3125, -0.25, 0.5},
		{-0.3125, -0.25, 0.25, 0.3125, -0.1875, 0.5},
		{-0.3125, -0.25, 0.3125, 0.3125, -0.125, 0.375},
		{-0.3125, -0.3125, 0.25, 0.3125, -0.1875, 0.3125},
		{-0.3125, -0.5, 0.375, 0.3125, 0.5, 0.5},
		{-0.0625, -0.5, -0.5, 0.0625, 0.5, 0.5}},
	type = "fixed"}

local scifi_nodes_pot_node_box = {fixed = {{-0.5, -0.25, -0.5, 0.5, 0.5, 0.5},
		{0.1875, -0.5, 0.1875, 0.5, -0.25, 0.5},
		{-0.5, -0.5, -0.5, -0.1875, -0.25, -0.1875},
		{-0.5, -0.5, 0.1875, -0.1875, -0.25, 0.5},
		{0.1875, -0.5, -0.5, 0.5, -0.25, -0.1875}},
	type = "fixed"}

local scifi_nodes_glass_pane_node_box = {fixed = {{-0.5, -0.5, -0.03125, 0.5, 0.5, 0.03125}},
	type = "fixed"}

local scifi_nodes_glass_pane_double_node_box = {fixed = {{-0.5, -0.5, -0.03125, 0.5, 1.5, 0.03125}},
	type = "fixed"}

local scifi_nodes_Doom_door_opened_node_box = {fixed = {{-0.5, -0.5, -0.0625, -0.25, 0.5, 0.0625}},
	type = "fixed"}

local scifi_nodes_pplwndw_node_box = {fixed = {{-0.5, -0.5, -0.0625, 0.5, 0.5, 0.0625}},
	type = "fixed"}

local scifi_nodes_glass_pane_offset_node_box = {fixed = {{-0.5, -0.5, 0.96875, 0.5, 0.5, 1.03125}},
	type = "fixed"}

local scifi_nodes_capsule_node_box = {fixed = {{0.3125, -0.5, -0.25, 0.5, 0, 0.25},
		{-0.5, -0.5, -0.25, -0.3125, 0, 0.25},
		{-0.3125, -0.4375, -0.1875, 0.3125, -0.0625, 0.1875}},
	type = "fixed"}

reg({_raw_name = "scifi_nodes:Doom_door_closed",
		description = "Doom sliding door",
		drawtype = "nodebox",
		inventory_image = "scifi_nodes_door_Doom_inv.png",
		node_box = scifi_nodes_pplwndw_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_rbottom.png",
		"scifi_nodes_door_Doom_bottom.png"},
		type = "node",
		wield_image = "scifi_nodes_door_Doom_inv.png"})

reg({_raw_name = "scifi_nodes:Doom_door_closed_top",
		drawtype = "nodebox",
		node_box = scifi_nodes_pplwndw_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_rtop.png",
		"scifi_nodes_door_Doom_top.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:Doom_door_opened",
		drawtype = "nodebox",
		node_box = scifi_nodes_Doom_door_opened_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_rbottom0.png",
		"scifi_nodes_door_Doom_bottom0.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:Doom_door_opened_top",
		drawtype = "nodebox",
		node_box = scifi_nodes_Doom_door_opened_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_edge.png",
			"scifi_nodes_door_Doom_rtopo.png",
		"scifi_nodes_door_Doom_topo.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:bfloor",
		description = "blue floor",
		light_source = 10,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_box_sounds,
		tiles = {"scifi_nodes_bluefloor.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:black",
		description = "black wall",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_black.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:black_detail",
		description = "black detail",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_black_detail.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:black_door_closed",
		description = "black sliding door",
		drawtype = "nodebox",
		inventory_image = "scifi_nodes_door_black_inv.png",
		node_box = scifi_nodes_pplwndw_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_rbottom.png",
		"scifi_nodes_door_black_bottom.png"},
		type = "node",
		wield_image = "scifi_nodes_door_black_inv.png"})

reg({_raw_name = "scifi_nodes:black_door_closed_top",
		drawtype = "nodebox",
		node_box = scifi_nodes_pplwndw_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_rtop.png",
		"scifi_nodes_door_black_top.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:black_door_opened",
		drawtype = "nodebox",
		node_box = scifi_nodes_Doom_door_opened_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_rbottom0.png",
		"scifi_nodes_door_black_bottom0.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:black_door_opened_top",
		drawtype = "nodebox",
		node_box = scifi_nodes_Doom_door_opened_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_edge.png",
			"scifi_nodes_door_black_rtopo.png",
		"scifi_nodes_door_black_topo.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:black_lights",
		description = "black wallpanel",
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {{animation = scifi_nodes_screen_tiles_1_animation,
				name = "scifi_nodes_black_lights.png"}},
		type = "node"})

reg({_raw_name = "scifi_nodes:black_mesh",
		description = "black vent block",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_black_mesh.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:black_screen",
		description = "black wall screen",
		light_source = 1,
		paramtype = "light",
		sounds = {dug = {gain = 1, name = "default_hard_footstep"},
			footstep = {gain = 0.2, name = "default_hard_footstep"},
			place = {gain = 1, name = "default_place_node_hard"}},
		sunlight_propagates = false,
		tiles = {{animation = {aspect_h = 16,
					aspect_w = 16,
					length = 2,
					type = "vertical_frames"},
				name = "scifi_nodes_black_screen.png"}},
		type = "node"})

reg({_raw_name = "scifi_nodes:blackdmg",
		description = "Damaged black wall",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_blackdmg.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blackdmgstripe",
		description = "Damaged black wall(stripes)",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_blackdmgstripe.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blackoct",
		description = "black octagon",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_blackoct.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blackpipe",
		description = "black pipe",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_blackpipe.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blackplate",
		description = "Black plate",
		light_source = 0,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_blackplate.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blacktile",
		description = "black tile",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_blacktile.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blacktile2",
		description = "black tile 2",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_blacktile2.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blackvent",
		description = "black vent",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_blackvent.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blackvnt",
		description = "Black vent",
		light_source = 0,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_blackvnt.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blink",
		description = "blinking light",
		light_source = 5,
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {{animation = {aspect_h = 16,
					aspect_w = 16,
					length = 2,
					type = "vertical_frames"},
				name = "scifi_nodes_lightbox.png"}},
		type = "node"})

reg({_raw_name = "scifi_nodes:blklt2",
		description = "black stripe light",
		light_source = 10,
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_black_light2.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blue",
		description = "blue lines",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_blue.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blue_door_closed",
		description = "blue sliding door",
		drawtype = "nodebox",
		inventory_image = "scifi_nodes_door_blue_inv.png",
		node_box = scifi_nodes_pplwndw_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_rbottom.png",
		"scifi_nodes_door_blue_bottom.png"},
		type = "node",
		wield_image = "scifi_nodes_door_blue_inv.png"})

reg({_raw_name = "scifi_nodes:blue_door_closed_top",
		drawtype = "nodebox",
		node_box = scifi_nodes_pplwndw_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_rtop.png",
		"scifi_nodes_door_blue_top.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blue_door_opened",
		drawtype = "nodebox",
		node_box = scifi_nodes_Doom_door_opened_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_rbottom0.png",
		"scifi_nodes_door_blue_bottom0.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blue_door_opened_top",
		drawtype = "nodebox",
		node_box = scifi_nodes_Doom_door_opened_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_edge.png",
			"scifi_nodes_door_blue_rtopo.png",
		"scifi_nodes_door_blue_topo.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blue_square",
		description = "blue metal block",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_blue_square.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:bluebars",
		description = "blue bars",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_bluebars.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:bluegrid",
		description = "Blue Grid",
		light_source = 5,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_bluegrid.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:bluemetal",
		description = "blue metal",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_bluemetal.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:bluetile",
		description = "blue tile",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_bluetile.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blumetlight",
		description = "blue metal light",
		light_source = 10,
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_bluemetal.png",
			"scifi_nodes_bluemetal.png",
			"scifi_nodes_blue_metal_light.png",
			"scifi_nodes_blue_metal_light.png",
			"scifi_nodes_blue_metal_light.png",
		"scifi_nodes_blue_metal_light.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:blumetstr",
		description = "blue stripe light",
		light_source = 10,
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_blue_metal_stripes2.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:bluwllight",
		description = "Blue wall light",
		light_source = 14,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_bluwllight.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:box",
		description = "Storage box",
		legacy_facedir_simple = true,
		paramtype2 = "facedir",
		sounds = scifi_nodes_box_sounds,
		tiles = {"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_box.png",
			"scifi_nodes_box.png",
			"scifi_nodes_box.png",
		"scifi_nodes_box.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:builder",
		description = "Sci-fi Node Builder",
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_builder.png",
			"scifi_nodes_builder.png",
			"scifi_nodes_builder_side.png",
			"scifi_nodes_builder_side.png",
			"scifi_nodes_builder_side.png",
		"scifi_nodes_builder_front.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:capsule",
		description = "sample capsule",
		drawtype = "nodebox",
		node_box = scifi_nodes_capsule_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_capsule.png",
			"scifi_nodes_capsule.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_capsule.png",
		"scifi_nodes_capsule.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:capsule2",
		description = "sample capsule",
		drawtype = "nodebox",
		node_box = scifi_nodes_capsule_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_capsule2.png",
			"scifi_nodes_capsule2.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_capsule2.png",
		"scifi_nodes_capsule2.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:capsule3",
		description = "sample capsule",
		drawtype = "nodebox",
		node_box = scifi_nodes_capsule_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_capsule3.png",
			"scifi_nodes_capsule3.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_capsule3.png",
		"scifi_nodes_capsule3.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:computer",
		description = "computer",
		drawtype = "nodebox",
		node_box = {fixed = {{-0.4375, -0.5, -0.5, 0.0625, 0.5, 0.5}},
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		tiles = {"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_blackvent.png",
			"scifi_nodes_black.png",
			"scifi_nodes_mesh2.png",
		"scifi_nodes_pc.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:cover",
		description = "Metal cover",
		drawtype = "nodebox",
		node_box = {fixed = {{-0.375, -0.5, -0.3125, 0.375, -0.375, 0.3125},
				{-0.3125, -0.5, -0.375, 0.3125, -0.375, 0.375},
				{-0.3125, -0.375, -0.3125, 0.3125, -0.3125, 0.3125}},
			type = "fixed"},
		paramtype = "light",
		sounds = scifi_nodes_cover_sounds,
		tiles = {"scifi_nodes_pwrstnd_top.png",
			"scifi_nodes_pwrstnd_top.png",
			"scifi_nodes_pwrstnd_top.png",
			"scifi_nodes_pwrstnd_top.png",
			"scifi_nodes_pwrstnd_top.png",
		"scifi_nodes_pwrstnd_top.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:crate",
		description = "Crate",
		legacy_facedir_simple = true,
		paramtype2 = "facedir",
		sounds = scifi_nodes_cover_sounds,
		tiles = {"scifi_nodes_crate.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:dent",
		description = "dented metal block",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_dent.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:digicode_off",
		description = "Digicode",
		drawtype = "signlike",
		inventory_image = "scifi_nodes_digicode_off.png",
		node_box = {type = "wallmounted"},
		paramtype = "light",
		paramtype2 = "wallmounted",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_digicode_off.png"},
		type = "node",
		wield_image = "scifi_nodes_digicode_off.png"})

reg({_raw_name = "scifi_nodes:digicode_on",
		description = "Digicode",
		drawtype = "signlike",
		inventory_image = "scifi_nodes_digicode_on.png",
		light_source = 5,
		node_box = {type = "wallmounted"},
		paramtype = "light",
		paramtype2 = "wallmounted",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_digicode_on.png"},
		type = "node",
		wield_image = "scifi_nodes_digicode_on.png"})

reg({_raw_name = "scifi_nodes:disc",
		description = "disc",
		drawtype = "torchlike",
		inventory_image = "scifi_nodes_disc.png",
		paramtype = "light",
		sunlight_propagates = false,
		tiles = {"scifi_nodes_disc.png"},
		type = "node",
		wield_image = "scifi_nodes_disc.png"})

reg({_raw_name = "scifi_nodes:discs",
		description = "disc shelves",
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_discs.png",
			"scifi_nodes_discs.png",
			"scifi_nodes_discs.png",
		"scifi_nodes_discs.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:doomengine",
		description = "Doom engine wall",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_doomengine.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:doomlight",
		description = "Doom light",
		light_source = 12,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_doomlight.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:doomwall1",
		description = "Doom wall 1",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_doomwall1.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:doomwall2",
		description = "Doom wall 2",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_doomwall2.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:doomwall3",
		description = "Doom wall 3",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_doomwall3.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:doomwall4",
		description = "Doom wall 4",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_doomwall4.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:doomwall41",
		description = "Doom wall 4.1",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_doomwall41.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:doomwall42",
		description = "Doom wall 4.2",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_doomwall42.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:doomwall43",
		description = "Doom wall 4.3",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_doomwall43.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:doomwall431",
		description = "Doom wall 4.3.1",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_doomwall431.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:doomwall44",
		description = "Doom wall 4.4",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_doomwall44.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:egg",
		description = "Alien Egg",
		drawtype = "nodebox",
		light_source = 5,
		node_box = {fixed = {{-0.25, -0.5, -0.25, 0.25, -0.4375, 0.25},
				{-0.375, -0.4375, -0.375, 0.375, -0.3125, 0.375},
				{-0.4375, -0.3125, -0.375, 0.4375, 0.3125, 0.375},
				{-0.375, 0.3125, -0.375, 0.375, 0.4375, 0.375},
				{-0.3125, 0.4375, -0.3125, 0.3125, 0.5625, 0.3125},
				{-0.25, 0.5625, -0.25, 0.25, 0.6875, 0.25},
				{-0.1875, 0.6875, -0.1875, 0.1875, 0.75, 0.1875},
				{-0.125, 0.75, -0.125, 0.125, 0.8125, 0.125},
				{-0.375, -0.3125, -0.4375, 0.375, 0.3125, 0.4375}},
			sounds = scifi_nodes_cover_sounds,
			type = "fixed"},
		paramtype = "light",
		sunlight_propagates = false,
		tiles = {"scifi_nodes_egg_top.png",
			"scifi_nodes_egg_top.png",
			"scifi_nodes_egg_side.png",
			"scifi_nodes_egg_side.png",
			"scifi_nodes_egg_side.png",
		"scifi_nodes_egg_side.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:engine",
		description = "engine",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_engine.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:eyetree",
		description = "Eye Tree",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_eyetree.png",
		light_source = 0,
		paramtype = "light",
		tiles = {"scifi_nodes_eyetree.png"},
		type = "node",
		visual_scale = 2.5,
		walkable = false})

reg({_raw_name = "scifi_nodes:fan",
		description = "Fan",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_fan.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:flower1",
		description = "Glow Flower",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_flower1.png",
		light_source = 14,
		paramtype = "light",
		tiles = {"scifi_nodes_flower1.png"},
		type = "node",
		visual_scale = 1,
		walkable = false})

reg({_raw_name = "scifi_nodes:flower2",
		description = "Pink Flower",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_flower2.png",
		light_source = 10,
		paramtype = "light",
		tiles = {"scifi_nodes_flower2.png"},
		type = "node",
		visual_scale = 1.5,
		walkable = false})

reg({_raw_name = "scifi_nodes:flower3",
		description = "Triffid",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_flower3.png",
		light_source = 0,
		paramtype = "light",
		tiles = {"scifi_nodes_flower3.png"},
		type = "node",
		visual_scale = 2,
		walkable = false})

reg({_raw_name = "scifi_nodes:flower4",
		description = "Weeping flower",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_flower4.png",
		light_source = 0,
		paramtype = "light",
		tiles = {"scifi_nodes_flower4.png"},
		type = "node",
		visual_scale = 1.5,
		walkable = false})

reg({_raw_name = "scifi_nodes:gblock",
		description = "Green metal block",
		paramtype = "light",
		sounds = scifi_nodes_box_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_gblock.png",
			"scifi_nodes_gblock.png",
			"scifi_nodes_gblock.png",
			"scifi_nodes_gblock.png",
			"scifi_nodes_gblock.png",
		"scifi_nodes_gblock.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:gblock2",
		description = "Green metal block 2",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_box_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_gblock2_top.png",
			"scifi_nodes_gblock.png",
			"scifi_nodes_gblock2.png",
			"scifi_nodes_gblock2_fx.png",
			"scifi_nodes_gblock.png",
		"scifi_nodes_gblock2_front1.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:gblock3",
		description = "Green metal block 3",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_box_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_gblock2_top.png",
			"scifi_nodes_gblock.png",
			"scifi_nodes_gblock2.png",
			"scifi_nodes_gblock2_fx.png",
			"scifi_nodes_gblock.png",
		"scifi_nodes_gblock2_screen.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:glass",
		description = "dark glass",
		drawtype = "glasslike",
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_glass.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:glass_pane",
		description = "Dark Glass pane",
		drawtype = "nodebox",
		node_box = scifi_nodes_glass_pane_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_glass.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_glass.png"})

reg({_raw_name = "scifi_nodes:glass_pane_double",
		description = "Dark Glass pane",
		drawtype = "nodebox",
		node_box = scifi_nodes_glass_pane_double_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_glass.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_glass.png"})

reg({_raw_name = "scifi_nodes:glass_pane_offset",
		description = "Dark Glass pane",
		drawtype = "nodebox",
		node_box = scifi_nodes_glass_pane_offset_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_glass.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_glass.png"})

reg({_raw_name = "scifi_nodes:glassscreen",
		description = "glass screen",
		drawtype = "nodebox",
		light_source = 14,
		node_box = {fixed = {{-0.4375, -0.5, -0.125, 0.4375, -0.1875, 0.0625},
				{-0.375, -0.5, -0.0625, 0.375, 0.5, 0}},
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_glscrn.png",
			"scifi_nodes_glscrn.png",
			"scifi_nodes_glscrn.png",
			"scifi_nodes_glscrn.png",
			"scifi_nodes_glscrn.png",
		"scifi_nodes_glscrn.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:gloshroom",
		description = "Gloshroom",
		drawtype = "nodebox",
		light_source = 14,
		node_box = {fixed = {{-0.05, -0.5, -0.05, 0.05, 0.0625, 0.05},
				{-0.4375, -0.0625, -0.375, 0.4375, 0, 0.375},
				{-0.375, 0, -0.375, 0.375, 0.0625, 0.375},
				{-0.3125, 0.0625, -0.3125, 0.3125, 0.125, 0.3125},
				{-0.1875, 0.125, -0.1875, 0.1875, 0.1875, 0.1875},
				{-0.375, -0.0625, -0.4375, 0.375, 0, 0.4375}},
			type = "fixed"},
		paramtype = "light",
		sunlight_propagates = false,
		tiles = {"scifi_nodes_gloshroom.png",
			"scifi_nodes_gloshroom_under.png",
			"scifi_nodes_gloshroom.png",
			"scifi_nodes_gloshroom.png",
			"scifi_nodes_gloshroom.png",
		"scifi_nodes_gloshroom.png"},
		type = "node",
		use_texture_alpha = "blend",
		walkable = false})

reg({_raw_name = "scifi_nodes:grass",
		description = "Alien Grass",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_grass.png",
		light_source = 0,
		paramtype = "light",
		tiles = {"scifi_nodes_grass.png"},
		type = "node",
		visual_scale = 1,
		walkable = false})

reg({_raw_name = "scifi_nodes:grassblk",
		description = "Dirt With Alien Grass",
		light_source = 2,
		tiles = {"default_grass.png^[colorize:cyan:80",
			"default_dirt.png",
			{name = "default_dirt.png^(default_grass_side.png^[colorize:cyan:80)",
				tileable_vertical = false}},
		type = "node"})

reg({_raw_name = "scifi_nodes:green",
		description = "green lines",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_green.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:green2",
		description = "green wall panel",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_green2.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:green_door_closed",
		description = "green sliding door",
		drawtype = "nodebox",
		inventory_image = "scifi_nodes_door_green_inv.png",
		node_box = scifi_nodes_pplwndw_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_rbottom.png",
		"scifi_nodes_door_green_bottom.png"},
		type = "node",
		wield_image = "scifi_nodes_door_green_inv.png"})

reg({_raw_name = "scifi_nodes:green_door_closed_top",
		drawtype = "nodebox",
		node_box = scifi_nodes_pplwndw_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_rtop.png",
		"scifi_nodes_door_green_top.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:green_door_opened",
		drawtype = "nodebox",
		node_box = scifi_nodes_Doom_door_opened_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_rbottom0.png",
		"scifi_nodes_door_green_bottom0.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:green_door_opened_top",
		drawtype = "nodebox",
		node_box = scifi_nodes_Doom_door_opened_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_edge.png",
			"scifi_nodes_door_green_rtopo.png",
		"scifi_nodes_door_green_topo.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:green_light",
		description = "green lightbox",
		light_source = 10,
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_lighttop.png",
			"scifi_nodes_lighttop.png",
			"scifi_nodes_greenlight.png",
			"scifi_nodes_greenlight.png",
			"scifi_nodes_greenlight.png",
		"scifi_nodes_greenlight.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:green_square",
		description = "green metal block",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_green_square.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:greenbar",
		description = "green light bar",
		light_source = 10,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_greenbar.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:greenbar_animated",
		description = "animated green light bar",
		light_source = 10,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_greenbar.png",
			"scifi_nodes_greenbar.png",
			{animation = {aspect_h = 16,
					aspect_w = 16,
					length = 1,
					type = "vertical_frames"},
				name = "scifi_nodes_greenbar_animated.png"}},
		type = "node"})

reg({_raw_name = "scifi_nodes:greenlights",
		description = "green wall lights",
		light_source = 10,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_greenlights.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:greenlights2",
		description = "green wall lights2",
		light_source = 10,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_greenlights2.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:greenmetal",
		description = "green metal wall",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_greenmetal.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:greenmetal2",
		description = "green metal wall2",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_greenmetal2.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:greentubes",
		description = "green pipes",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_greentubes.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:grey",
		description = "grey wall",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_grey.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:grey_square",
		description = "grey metal block",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_grey_square.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:greybars",
		description = "grey bars",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_greybars.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:greybolts",
		description = "grey wall bolts",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_greybolts.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:greydots",
		description = "grey wall dots",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_greydots.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:greygreenbar",
		description = "gray power pipe",
		light_source = 10,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_greygreenbar.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:greytile",
		description = "grey tile",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_greytile.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:grnpipe",
		description = "green pipe",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_box_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_greenpipe_front.png",
			"scifi_nodes_greenpipe_front.png",
			"scifi_nodes_greenpipe_top.png",
			"scifi_nodes_greenpipe_top.png",
			"scifi_nodes_greenpipe_top.png",
		"scifi_nodes_greenpipe_top.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:grnpipe2",
		description = "broken green pipe",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_box_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_greenpipe_front.png",
			"scifi_nodes_greenpipe_front.png",
			"scifi_nodes_greenpipe2_top.png",
			"scifi_nodes_greenpipe2_top.png",
			"scifi_nodes_greenpipe2_top.png",
		"scifi_nodes_greenpipe2_top.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:holes",
		description = "metal with holes",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_holes.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:itemholder",
		description = "item holder",
		drawtype = "nodebox",
		node_box = {fixed = {{-0.3125, -0.5, -0.3125, 0.3125, -0.25, 0.3125},
				{-0.0625, -0.5, 0.1875, 0.0625, -0.0625, 0.25},
				{-0.0625, -0.5, -0.25, 0.0625, -0.0625, -0.1875},
				{0.1875, -0.5, -0.0625, 0.25, -0.0625, 0.0625},
				{-0.25, -0.5, -0.0625, -0.1875, -0.0625, 0.0625}},
			type = "fixed"},
		paramtype = "light",
		sunlight_propagates = true,
		tiles = {"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
			"scifi_nodes_box_top.png",
		"scifi_nodes_box_top.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:junk",
		description = "Junk",
		paramtype = "light",
		sunlight_propagates = true,
		tiles = {"scifi_nodes_junk.png"},
		type = "node",
		walkable = false})

reg({_raw_name = "scifi_nodes:keysmonitor",
		description = "Keyboard and monitor",
		drawtype = "nodebox",
		node_box = {fixed = {{-0.5, -0.5, -0.4375, 0.5, -0.4375, -0.0625},
				{-0.125, -0.5, 0.375, 0.125, 0.0625, 0.4375},
				{-0.25, -0.5, 0.125, 0.25, -0.4375, 0.5},
				{-0.5, -0.3125, 0.25, 0.5, 0.5, 0.375}},
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		tiles = {"scifi_nodes_keyboard.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
		"scifi_nodes_monitor.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:ladder",
		climbable = true,
		description = "Metal Ladder",
		drawtype = "nodebox",
		node_box = {fixed = {{0.3125, -0.5, -0.4375, 0.4375, -0.375, -0.3125},
				{-0.4375, -0.5, -0.4375, -0.3125, -0.375, -0.3125},
				{-0.375, -0.375, -0.4375, 0.375, -0.3125, -0.3125},
				{-0.375, -0.375, 0.3125, 0.375, -0.3125, 0.4375},
				{-0.375, -0.375, 0.0625, 0.375, -0.3125, 0.1875},
				{-0.375, -0.375, -0.1875, 0.375, -0.3125, -0.0625},
				{-0.4375, -0.5, -0.1875, -0.3125, -0.375, -0.0625},
				{-0.4375, -0.5, 0.0625, -0.3125, -0.375, 0.1875},
				{-0.4375, -0.5, 0.3125, -0.3125, -0.375, 0.4375},
				{0.3125, -0.5, 0.3125, 0.4375, -0.375, 0.4375},
				{0.3125, -0.5, 0.0625, 0.4375, -0.375, 0.1875},
				{0.3125, -0.5, -0.1875, 0.4375, -0.375, -0.0625}},
			sounds = scifi_nodes_box_sounds,
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "wallmounted",
		tiles = {"scifi_nodes_ladder.png"},
		type = "node",
		walkable = false})

reg({_raw_name = "scifi_nodes:laptop_closed",
		description = "laptop",
		drawtype = "nodebox",
		node_box = {fixed = {{-0.4375, -0.5, -0.4375, 0.4375, -0.25, 0.3125}},
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		tiles = {"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
		"scifi_nodes_black.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:laptop_open",
		description = "laptop",
		drawtype = "nodebox",
		node_box = {fixed = {{-0.4375, -0.5, -0.4375, 0.4375, -0.375, 0.3125},
				{-0.4375, -0.375, 0.3125, 0.4375, 0.4375, 0.4375}},
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		tiles = {"scifi_nodes_lapkey.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
		"scifi_nodes_laptop.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:light",
		description = "blue lightbox",
		light_source = 10,
		paramtype = "light",
		sunlight_propagates = false,
		tiles = {"scifi_nodes_lighttop.png",
			"scifi_nodes_lighttop.png",
			"scifi_nodes_light.png",
			"scifi_nodes_light.png",
			"scifi_nodes_light.png",
		"scifi_nodes_light.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:light_dynamic",
		description = "Wall light",
		drawtype = "signlike",
		inventory_image = "scifi_nodes_lightoverlay.png",
		light_source = 14,
		node_box = {fixed = {fixed = {-0.5, -0.5, -0.5, -0.45, 0.5, 0.5}},
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "wallmounted",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_lightoverlay.png"},
		type = "node",
		wield_image = "scifi_nodes_lightoverlay.png"})

reg({_raw_name = "scifi_nodes:lightbar",
		description = "ceiling light",
		drawtype = "nodebox",
		light_source = 14,
		node_box = {fixed = {{-0.125, -0.5, -0.5, 0.125, -0.375, 0.5}},
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "wallmounted",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_white2.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:lightbars",
		description = "orange lightbars",
		drawtype = "nodebox",
		light_source = 14,
		node_box = {fixed = {{0.125, -0.5, 0.125, 0.375, 0.5, 0.375},
				{-0.375, -0.5, 0.125, -0.125, 0.5, 0.375},
				{-0.375, -0.5, -0.375, -0.125, 0.5, -0.125},
				{0.125, -0.5, -0.375, 0.375, 0.5, -0.125}},
			type = "fixed"},
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_orange2.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:lightstp",
		description = "twin lights",
		light_source = 14,
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_lightstripe.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:lighttop",
		description = "metal block",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_lighttop.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:liquid_pipe",
		description = "Liquid pipe",
		drawtype = "nodebox",
		light_source = 14,
		node_box = {fixed = {{-0.375, -0.5, -0.375, 0.375, 0.5, 0.375}},
			type = "fixed"},
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {{animation = {aspect_h = 16,
					aspect_w = 16,
					length = 1,
					type = "vertical_frames"},
				name = "scifi_nodes_liquid.png"}},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:liquid_pipe2",
		description = "Liquid pipe 2",
		drawtype = "nodebox",
		light_source = 14,
		node_box = {fixed = {{-0.375, -0.5, -0.375, 0.375, 0.5, 0.375}},
			type = "fixed"},
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_orange.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:mesh",
		description = "metal mesh",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_mesh.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:mesh2",
		description = "metal floormesh",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_mesh2.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:microscope",
		description = "Microscope",
		drawtype = "nodebox",
		node_box = {fixed = {{-0.25, -0.5, -0.3125, 0.25, -0.375, 0.3125},
				{-0.0625, -0.5, 0.125, 0.0625, 0.3125, 0.25},
				{-0.0625, -0.0625, -0.0625, 0.0625, 0.5, 0.0625},
				{-0.0625, 0.0625, 0.0625, 0.0625, 0.25, 0.125},
				{-0.125, -0.25, -0.125, 0.125, -0.1875, 0.1875}},
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		tiles = {"scifi_nodes_white.png",
			"scifi_nodes_black.png",
			"scifi_nodes_white_vent.png",
			"scifi_nodes_white_vent.png",
			"scifi_nodes_white_vent.png",
		"scifi_nodes_white_vent.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:monitorwall",
		description = "Wall monitors",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_monitorwall.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:octbl",
		description = "Blue Octagon Glass",
		drawtype = "glasslike",
		light_source = 10,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_octbl.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:octbl_pane",
		description = "Blue Octagon Glass pane",
		drawtype = "nodebox",
		node_box = scifi_nodes_glass_pane_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_octbl.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_octbl.png"})

reg({_raw_name = "scifi_nodes:octbl_pane_double",
		description = "Blue Octagon Glass pane",
		drawtype = "nodebox",
		node_box = scifi_nodes_glass_pane_double_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_octbl.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_octbl.png"})

reg({_raw_name = "scifi_nodes:octbl_pane_offset",
		description = "Blue Octagon Glass pane",
		drawtype = "nodebox",
		node_box = scifi_nodes_glass_pane_offset_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_octbl.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_octbl.png"})

reg({_raw_name = "scifi_nodes:octgrn",
		description = "Green Octagon Glass",
		drawtype = "glasslike",
		light_source = 10,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_octgrn.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:octgrn_pane",
		description = "Green Octagon Glass pane",
		drawtype = "nodebox",
		node_box = scifi_nodes_glass_pane_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_octgrn.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_octgrn.png"})

reg({_raw_name = "scifi_nodes:octgrn_pane_double",
		description = "Green Octagon Glass pane",
		drawtype = "nodebox",
		node_box = scifi_nodes_glass_pane_double_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_octgrn.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_octgrn.png"})

reg({_raw_name = "scifi_nodes:octgrn_pane_offset",
		description = "Green Octagon Glass pane",
		drawtype = "nodebox",
		node_box = scifi_nodes_glass_pane_offset_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_octgrn.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_octgrn.png"})

reg({_raw_name = "scifi_nodes:octofloor",
		description = "Doom floor",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_octofloor.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:octofloor2",
		description = "Brown Doom floor",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_octofloor2.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:octppl",
		description = "Purple Octagon Glass",
		drawtype = "glasslike",
		light_source = 10,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_octppl.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:octppl_pane",
		description = "Purple Octagon Glass pane",
		drawtype = "nodebox",
		node_box = scifi_nodes_glass_pane_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_octppl.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_octppl.png"})

reg({_raw_name = "scifi_nodes:octppl_pane_double",
		description = "Purple Octagon Glass pane",
		drawtype = "nodebox",
		node_box = scifi_nodes_glass_pane_double_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_octppl.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_octppl.png"})

reg({_raw_name = "scifi_nodes:octppl_pane_offset",
		description = "Purple Octagon Glass pane",
		drawtype = "nodebox",
		node_box = scifi_nodes_glass_pane_offset_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_octppl.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_octppl.png"})

reg({_raw_name = "scifi_nodes:octrng",
		description = "Orange Octagon Glass",
		drawtype = "glasslike",
		light_source = 10,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_octrng.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:octrng_pane",
		description = "Orange Octagon Glass pane",
		drawtype = "nodebox",
		node_box = scifi_nodes_glass_pane_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_octrng.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_octrng.png"})

reg({_raw_name = "scifi_nodes:octrng_pane_double",
		description = "Orange Octagon Glass pane",
		drawtype = "nodebox",
		node_box = scifi_nodes_glass_pane_double_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_octrng.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_octrng.png"})

reg({_raw_name = "scifi_nodes:octrng_pane_offset",
		description = "Orange Octagon Glass pane",
		drawtype = "nodebox",
		node_box = scifi_nodes_glass_pane_offset_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_octrng.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_octrng.png"})

reg({_raw_name = "scifi_nodes:pad",
		description = "teleport pad",
		drawtype = "nodebox",
		light_source = 5,
		node_box = {fixed = {{-0.9375, -0.5, -0.75, 0.875, -0.375, 0.75},
				{-0.8125, -0.5, -0.875, 0.75, -0.375, 0.875},
				{-0.875, -0.5, -0.8125, 0.8125, -0.375, 0.8125},
				{-0.8125, -0.5, -0.75, 0.75, -0.3125, 0.75}},
			sounds = scifi_nodes_cover_sounds,
			type = "fixed"},
		paramtype = "light",
		tiles = {"scifi_nodes_pad.png",
			"scifi_nodes_pad.png",
			"scifi_nodes_pad.png",
			"scifi_nodes_pad.png",
			"scifi_nodes_pad.png",
		"scifi_nodes_pad.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:palm_scanner_checking",
		description = "Palm scanner",
		drawtype = "signlike",
		node_box = {type = "wallmounted"},
		paramtype = "light",
		paramtype2 = "wallmounted",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {{animation = {aspect_h = 16,
					aspect_w = 16,
					length = 1.5,
					type = "vertical_frames"},
				name = "scifi_nodes_palm_scanner_checking.png"}},
		type = "node"})

reg({_raw_name = "scifi_nodes:palm_scanner_off",
		description = "Palm scanner",
		drawtype = "signlike",
		inventory_image = "scifi_nodes_palm_scanner_off.png",
		node_box = {type = "wallmounted"},
		paramtype = "light",
		paramtype2 = "wallmounted",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_palm_scanner_off.png"},
		type = "node",
		wield_image = "scifi_nodes_palm_scanner_on.png"})

reg({_raw_name = "scifi_nodes:palm_scanner_on",
		description = "Palm scanner",
		drawtype = "signlike",
		inventory_image = "scifi_nodes_palm_scanner_on.png",
		light_source = 5,
		node_box = {type = "wallmounted"},
		paramtype = "light",
		paramtype2 = "wallmounted",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_palm_scanner_on.png"},
		type = "node",
		wield_image = "scifi_nodes_palm_scanner_on.png"})

reg({_raw_name = "scifi_nodes:pipe",
		description = "wall pipe",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_pipe.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:pipen",
		description = "pipe(nodebox)",
		drawtype = "nodebox",
		node_box = {fixed = {{-0.4375, -0.5, -0.4375, 0.4375, 0.5, 0.4375},
				{-0.5, 0.4375, -0.5, 0.5, 0.5, 0.5},
				{-0.5, 0.3125, -0.5, 0.5, 0.375, 0.5},
				{-0.5, 0.1875, -0.5, 0.5, 0.25, 0.5},
				{-0.5, 0.0625, -0.5, 0.5, 0.125, 0.5},
				{-0.5, -0.0625, -0.5, 0.5, 0, 0.5},
				{-0.5, -0.1875, -0.5, 0.5, -0.125, 0.5},
				{-0.5, -0.3125, -0.5, 0.5, -0.25, 0.5},
				{-0.5, -0.4375, -0.5, 0.5, -0.375, 0.5}},
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_blacktile2.png",
			"scifi_nodes_blacktile2.png",
			"scifi_nodes_pipen.png",
			"scifi_nodes_pipen.png",
			"scifi_nodes_pipen.png",
		"scifi_nodes_pipen.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:pipeside",
		description = "side pipe",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_pipeside.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:plant1",
		description = "Bulb Plant",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_plant1.png",
		light_source = 0,
		paramtype = "light",
		tiles = {"scifi_nodes_plant1.png"},
		type = "node",
		visual_scale = 1,
		walkable = false})

reg({_raw_name = "scifi_nodes:plant10",
		description = "Umbrella weed",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_plant10.png",
		light_source = 10,
		paramtype = "light",
		tiles = {"scifi_nodes_plant10.png"},
		type = "node",
		visual_scale = 1,
		walkable = false})

reg({_raw_name = "scifi_nodes:plant2",
		description = "Trap Plant",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_plant2.png",
		light_source = 14,
		paramtype = "light",
		tiles = {"scifi_nodes_plant2.png"},
		type = "node",
		visual_scale = 1.5,
		walkable = false})

reg({_raw_name = "scifi_nodes:plant3",
		description = "Blue Jelly Plant",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_plant3.png",
		light_source = 10,
		paramtype = "light",
		tiles = {"scifi_nodes_plant3.png"},
		type = "node",
		visual_scale = 1.2,
		walkable = false})

reg({_raw_name = "scifi_nodes:plant4",
		description = "Green Jelly Plant",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_plant4.png",
		light_source = 10,
		paramtype = "light",
		tiles = {"scifi_nodes_plant4.png"},
		type = "node",
		visual_scale = 1.2,
		walkable = false})

reg({_raw_name = "scifi_nodes:plant5",
		description = "Fern Plant",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_plant5.png",
		light_source = 0,
		paramtype = "light",
		tiles = {"scifi_nodes_plant5.png"},
		type = "node",
		visual_scale = 1.7,
		walkable = false})

reg({_raw_name = "scifi_nodes:plant6",
		description = "Curly Plant",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_plant6.png",
		light_source = 10,
		paramtype = "light",
		tiles = {"scifi_nodes_plant6.png"},
		type = "node",
		visual_scale = 1,
		walkable = false})

reg({_raw_name = "scifi_nodes:plant7",
		description = "Egg weed",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_plant7.png",
		light_source = 0,
		paramtype = "light",
		tiles = {"scifi_nodes_plant7.png"},
		type = "node",
		visual_scale = 1,
		walkable = false})

reg({_raw_name = "scifi_nodes:plant8",
		description = "Slug weed",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_plant8.png",
		light_source = 10,
		paramtype = "light",
		tiles = {"scifi_nodes_plant8.png"},
		type = "node",
		visual_scale = 1,
		walkable = false})

reg({_raw_name = "scifi_nodes:plant9",
		description = "Prickly Plant",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_plant9.png",
		light_source = 0,
		paramtype = "light",
		tiles = {"scifi_nodes_plant9.png"},
		type = "node",
		visual_scale = 1,
		walkable = false})

reg({_raw_name = "scifi_nodes:plant_trap",
		description = "Hanging Trap Plant",
		drawtype = "nodebox",
		light_source = 5,
		node_box = {fixed = {{-0.125, -0.4375, -0.125, 0.125, 0.125, 0.125},
				{-0.1875, 0.125, -0.1875, 0.1875, 0.1875, 0.1875},
				{-0.0625, -0.5, -0.0625, 0, -0.4375, 0.375},
				{-0.0625, -0.5, 0.3125, 0, 0.5, 0.375}},
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_cover_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_traplant_top.png",
			"scifi_nodes_traplant_side.png",
			"scifi_nodes_traplant_side.png",
			"scifi_nodes_traplant_side.png",
			"scifi_nodes_traplant_side.png",
		"scifi_nodes_traplant_side.png"},
		type = "node",
		walkable = false})

reg({_raw_name = "scifi_nodes:pot",
		description = "Metal Plant Pot (right-click for lid, sneak + right-click to plant)",
		drawtype = "nodebox",
		node_box = scifi_nodes_pot_node_box,
		paramtype = "light",
		sounds = scifi_nodes_box_sounds,
		tiles = {"default_dirt.png^scifi_nodes_pot.png",
			"scifi_nodes_greybolts.png",
			"scifi_nodes_greybolts.png",
			"scifi_nodes_greybolts.png",
			"scifi_nodes_greybolts.png",
		"scifi_nodes_greybolts.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:pot2",
		description = "Metal Plant Pot Wet (right-click for lid, sneak + right-click to plant)",
		drawtype = "nodebox",
		node_box = scifi_nodes_pot_node_box,
		paramtype = "light",
		sounds = scifi_nodes_box_sounds,
		tiles = {"default_dirt.png^scifi_nodes_pot2.png",
			"scifi_nodes_greybolts.png",
			"scifi_nodes_greybolts.png",
			"scifi_nodes_greybolts.png",
			"scifi_nodes_greybolts.png",
		"scifi_nodes_greybolts.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:pot_lid",
		description = "Plant Pot Lid",
		drawtype = "nodebox",
		inventory_image = "scifi_nodes_pod_inv.png",
		node_box = {fixed = {{-0.4375, -1.5, -0.4375, 0.4375, -0.5, -0.375},
				{-0.4375, -1.5, 0.375, 0.4375, -0.5, 0.4375},
				{-0.4375, -1.5, -0.375, -0.375, -0.5, 0.375},
				{0.375, -1.5, -0.375, 0.4375, -0.5, 0.375},
				{-0.375, -0.5, -0.375, 0.375, -0.4375, 0.375},
				{-0.3125, -0.4375, -0.3125, 0.3125, -0.375, 0.3125},
				{-0.25, -0.375, -0.25, 0.25, -0.3125, 0.25},
				{-0.1875, -0.3125, -0.1875, 0.1875, -0.25, 0.1875}},
			type = "fixed"},
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_glass2.png"},
		type = "node",
		use_texture_alpha = "blend",
		wield_image = "scifi_nodes_pod_inv.png"})

reg({_raw_name = "scifi_nodes:powered_stand",
		description = "powered stand",
		drawtype = "nodebox",
		node_box = {fixed = {{-0.375, 0.25, -0.3125, 0.375, 0.4375, 0.3125},
				{-0.3125, 0.25, -0.375, 0.3125, 0.4375, 0.375},
				{-0.3125, 0.4375, -0.3125, 0.3125, 0.5, 0.3125},
				{-0.5, -0.5, -0.125, 0.5, 0.125, 0.125},
				{-0.125, -0.5, -0.5, 0.125, 0.125, 0.5},
				{-0.4375, 0.125, -0.125, 0.4375, 0.25, 0.125},
				{-0.125, 0.125, -0.4375, 0.125, 0.25, 0.4375},
				{-0.3125, -0.5, -0.375, 0.3125, 0.0625, 0.3125},
				{-0.25, 0.0625, -0.3125, 0.25, 0.125, 0.3125}},
			type = "fixed"},
		paramtype = "light",
		tiles = {"scifi_nodes_pwrstnd_top.png",
			"scifi_nodes_pwrstnd_top.png",
			"scifi_nodes_pwrstnd_side.png",
			"scifi_nodes_pwrstnd_side.png",
			"scifi_nodes_pwrstnd_side.png",
		"scifi_nodes_pwrstnd_side.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:pplblk",
		description = "Purple tile",
		light_source = 0,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_pplblk.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:ppllght",
		description = "Purple wall light",
		light_source = 14,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_ppllght.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:pplwll",
		description = "Purple wall",
		light_source = 0,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_pplwll.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:pplwll2",
		description = "Purple wall2",
		light_source = 0,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_pplwll2.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:pplwll3",
		description = "Purple wall3",
		light_source = 0,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_pplwll3.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:pplwll4",
		description = "Purple wall4",
		light_source = 0,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_pplwll4.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:pplwndw",
		description = "Purple Window",
		drawtype = "nodebox",
		node_box = scifi_nodes_pplwndw_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_purple.png",
			"scifi_nodes_purple.png",
			"scifi_nodes_purple.png",
			"scifi_nodes_purple.png",
			"scifi_nodes_pplwndw.png",
		"scifi_nodes_pplwndw.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:protected_switch_off",
		description = "Protected wall switch",
		drawtype = "signlike",
		inventory_image = "scifi_nodes_switch_on.png",
		node_box = {type = "wallmounted"},
		paramtype = "light",
		paramtype2 = "wallmounted",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_switch_off.png"},
		type = "node",
		wield_image = "scifi_nodes_switch_on.png"})

reg({_raw_name = "scifi_nodes:protected_switch_on",
		description = "Protected wall switch",
		drawtype = "signlike",
		inventory_image = "scifi_nodes_switch_on.png",
		light_source = 5,
		node_box = {type = "wallmounted"},
		paramtype = "light",
		paramtype2 = "wallmounted",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_switch_on.png"},
		type = "node",
		wield_image = "scifi_nodes_switch_on.png"})

reg({_raw_name = "scifi_nodes:purple",
		description = "Purple node",
		light_source = 0,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_purple.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:red",
		description = "red lines",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_red.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:red_light",
		description = "red lightbox",
		light_source = 10,
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_lighttop.png",
			"scifi_nodes_lighttop.png",
			"scifi_nodes_redlight.png",
			"scifi_nodes_redlight.png",
			"scifi_nodes_redlight.png",
		"scifi_nodes_redlight.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:red_square",
		description = "red metal block",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_red_square.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:rfloor",
		description = "rusty floor",
		light_source = 10,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_box_sounds,
		tiles = {"scifi_nodes_rustfloor.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:rock",
		description = "Moonstone",
		light_source = 0,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_rock.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:rock2",
		description = "Moonstone2",
		light_source = 0,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_rock2.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:rough",
		description = "rough metal",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_rough.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:rust",
		description = "rusty metal",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_rust.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:screen",
		description = "electronic screen",
		light_source = 5,
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {{animation = scifi_nodes_screen_tiles_1_animation,
				name = "scifi_nodes_screen.png"}},
		type = "node"})

reg({_raw_name = "scifi_nodes:screen2",
		description = "electronic screen 2",
		light_source = 5,
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {{animation = scifi_nodes_screen_tiles_1_animation,
				name = "scifi_nodes_screen2.png"}},
		type = "node"})

reg({_raw_name = "scifi_nodes:screen3",
		description = "Wall monitor",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_screen3.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:stripes",
		description = "hazard stripes",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_stripes.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:stripes2",
		description = "hazard stripes2",
		paramtype = "light",
		sounds = scifi_nodes_box_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_stripes2top.png",
			"scifi_nodes_stripes2top.png",
			"scifi_nodes_stripes2.png",
			"scifi_nodes_stripes2.png",
			"scifi_nodes_stripes2.png",
		"scifi_nodes_stripes2.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:stripes2top",
		description = "dirty metal block",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_stripes2top.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:super_white",
		description = "Super Plastic",
		light_source = 11,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_super_white.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:switch_off",
		description = "Wall switch",
		drawtype = "signlike",
		inventory_image = "scifi_nodes_switch_on.png",
		node_box = {type = "wallmounted"},
		paramtype = "light",
		paramtype2 = "wallmounted",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_switch_off.png"},
		type = "node",
		wield_image = "scifi_nodes_switch_on.png"})

reg({_raw_name = "scifi_nodes:switch_on",
		description = "Wall switch",
		drawtype = "signlike",
		inventory_image = "scifi_nodes_switch_on.png",
		light_source = 5,
		node_box = {type = "wallmounted"},
		paramtype = "light",
		paramtype2 = "wallmounted",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_switch_on.png"},
		type = "node",
		wield_image = "scifi_nodes_switch_on.png"})

reg({_raw_name = "scifi_nodes:table",
		description = "Metal table",
		drawtype = "nodebox",
		node_box = {fixed = {{-0.5, 0.4375, -0.5, 0.5, 0.5, 0.5},
				{-0.0625, -0.5, 0.125, 0.0625, 0.5, 0.3125},
				{-0.0625, -0.5, 0.375, 0.0625, 0.5, 0.4375},
				{-0.0625, -0.375, 0.0625, 0.0625, 0.4375, 0.125},
				{-0.0625, -0.1875, 0, 0.0625, 0.4375, 0.0625},
				{-0.0625, 0.0625, -0.0625, 0.0625, 0.4375, 0},
				{-0.0625, 0.25, -0.125, 0.0625, 0.4375, -0.0625}},
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_box_sounds,
		tiles = {"scifi_nodes_grey.png",
			"scifi_nodes_grey.png",
			"scifi_nodes_grey.png",
			"scifi_nodes_grey.png",
			"scifi_nodes_grey.png",
		"scifi_nodes_grey.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:tallscreen",
		description = "tallscreen",
		drawtype = "nodebox",
		light_source = 5,
		node_box = {fixed = {{-0.3125, -0.375, 0.4375, 0.3125, 0.375, 0.5},
				{-0.375, 0.375, 0.375, 0.375, 0.5, 0.5},
				{-0.375, -0.5, 0.375, 0.375, -0.375, 0.5},
				{0.25, -0.3125, 0.375, 0.375, 0.3125, 0.5},
				{-0.375, -0.25, 0.375, -0.25, 0.3125, 0.5},
				{-0.3125, -0.5, 0.375, -0.25, 0.5, 0.5},
				{0.25, -0.5, 0.375, 0.3125, 0.5, 0.5}},
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		tiles = {"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
		"scifi_nodes_tallscreen.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:tile",
		description = "white tile",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_tile.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:tower",
		description = "Wind tower",
		drawtype = "plantlike",
		inventory_image = "scifi_nodes_tower.png",
		paramtype = "light",
		sounds = scifi_nodes_box_sounds,
		sunlight_propagates = false,
		tiles = {{animation = {aspect_h = 32,
					aspect_w = 32,
					length = 1,
					type = "vertical_frames"},
				name = "scifi_nodes_tower_anim.png"}},
		type = "node",
		visual_scale = 2})

reg({_raw_name = "scifi_nodes:ultra_white",
		description = "Ultra Plastic",
		light_source = 14,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_ultra_white.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:vent2",
		description = "vent",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_vent2.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:wall",
		description = "metal wall",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_wall.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:wallpipe",
		description = "Alien wall pipe",
		drawtype = "nodebox",
		node_box = {fixed = {{-0.5, -0.5, 0.125, 0.5, 0.5, 0.5},
				{-0.1875, -0.5, -0.0625, 0.1875, 0.5, 0.125},
				{-0.125, -0.5, -0.125, 0.125, 0.5, 0.125},
				{0.3125, -0.5, 0.0625, 0.4375, 0.5, 0.125},
				{-0.4375, -0.5, 0.0625, -0.3125, 0.5, 0.125},
				{-0.5, 0.0625, 0, 0.5, 0.1875, 0.0625},
				{-0.5, -0.125, 0, 0.5, 0, 0.0625}},
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_cover_sounds,
		tiles = {"scifi_nodes_wallpipe.png",
			"scifi_nodes_wallpipe.png",
			"scifi_nodes_wallpipe.png",
			"scifi_nodes_wallpipe.png",
			"scifi_nodes_wallpipe.png",
		"scifi_nodes_wallpipe.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:white",
		description = "plastic wall",
		light_source = 0,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_white.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:white2",
		description = "plastic",
		light_source = 0,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_white2.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:white_base",
		description = "white wall base",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_white2.png",
			"scifi_nodes_white2.png",
			"scifi_nodes_white_side.png",
			"scifi_nodes_white_side.png",
			"scifi_nodes_white_side.png",
		"scifi_nodes_white_side.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:white_door_closed",
		description = "white sliding door",
		drawtype = "nodebox",
		inventory_image = "scifi_nodes_door_white_inv.png",
		node_box = scifi_nodes_pplwndw_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_rbottom.png",
		"scifi_nodes_door_white_bottom.png"},
		type = "node",
		wield_image = "scifi_nodes_door_white_inv.png"})

reg({_raw_name = "scifi_nodes:white_door_closed_top",
		drawtype = "nodebox",
		node_box = scifi_nodes_pplwndw_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_rtop.png",
		"scifi_nodes_door_white_top.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:white_door_opened",
		drawtype = "nodebox",
		node_box = scifi_nodes_Doom_door_opened_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_rbottom0.png",
		"scifi_nodes_door_white_bottom0.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:white_door_opened_top",
		drawtype = "nodebox",
		node_box = scifi_nodes_Doom_door_opened_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		tiles = {"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_edge.png",
			"scifi_nodes_door_white_rtopo.png",
		"scifi_nodes_door_white_topo.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:white_pad",
		description = "white keypad",
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_white2.png",
			"scifi_nodes_white2.png",
			"scifi_nodes_white2.png",
			"scifi_nodes_white2.png",
			"scifi_nodes_white2.png",
		"scifi_nodes_white_pad.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:whiteoct",
		description = "white octagon",
		light_source = 0,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_whiteoct.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:whitetile",
		description = "white tile2",
		light_source = 0,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		tiles = {"scifi_nodes_whitetile.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:whtlightbnd",
		description = "white light stripe",
		light_source = 10,
		paramtype = "light",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = false,
		tiles = {"scifi_nodes_lightband.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:widescreen",
		description = "widescreen",
		drawtype = "nodebox",
		light_source = 5,
		node_box = {fixed = {{-0.375, -0.3125, 0.4375, 0.375, 0.3125, 0.5},
				{-0.5, -0.375, 0.375, -0.375, 0.375, 0.5},
				{0.375, -0.375, 0.375, 0.5, 0.375, 0.5},
				{-0.3125, 0.25, 0.375, 0.3125, 0.375, 0.5},
				{-0.3125, -0.375, 0.375, 0.25, -0.25, 0.5},
				{-0.5, -0.3125, 0.375, 0.5, -0.25, 0.5},
				{-0.5, 0.25, 0.375, 0.5, 0.3125, 0.5}},
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		tiles = {"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
			"scifi_nodes_black.png",
		"scifi_nodes_widescreen.png"},
		type = "node"})

reg({_raw_name = "scifi_nodes:windowcorner",
		description = "strong window corner",
		drawtype = "nodebox",
		node_box = scifi_nodes_windowcorner_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_glassstrngsd2.png",
			"scifi_nodes_white.png",
			"scifi_nodes_glassstrngcrnr.png",
			"scifi_nodes_glassstrngcrnr2.png",
			"scifi_nodes_white.png",
		"scifi_nodes_glassstrngsd.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:windowcorner2",
		description = "strong window corner(black)",
		drawtype = "nodebox",
		node_box = scifi_nodes_windowcorner_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_glassstrngsd4.png",
			"scifi_nodes_black.png",
			"scifi_nodes_glassstrngcrnr3.png",
			"scifi_nodes_glassstrngcrnr4.png",
			"scifi_nodes_black.png",
		"scifi_nodes_glassstrngsd3.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:windowpanel",
		description = "strong window panel",
		drawtype = "nodebox",
		node_box = {fixed = {{-0.0625, -0.5, -0.5, 0.0625, 0.5, 0.5}},
			type = "fixed"},
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_glass.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:windowstraight",
		description = "strong window",
		drawtype = "nodebox",
		node_box = scifi_nodes_windowstraight_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_glassstrngsd2.png",
			"scifi_nodes_white.png",
			"scifi_nodes_glassstrng.png",
			"scifi_nodes_glassstrng.png",
			"scifi_nodes_glassstrngsd.png",
		"scifi_nodes_glassstrngsd.png"},
		type = "node",
		use_texture_alpha = "blend"})

reg({_raw_name = "scifi_nodes:windowstraight2",
		description = "strong window(black)",
		drawtype = "nodebox",
		node_box = scifi_nodes_windowstraight_node_box,
		paramtype = "light",
		paramtype2 = "facedir",
		sounds = scifi_nodes_fan_sounds,
		sunlight_propagates = true,
		tiles = {"scifi_nodes_glassstrngsd4.png",
			"scifi_nodes_black.png",
			"scifi_nodes_glassstrng2.png",
			"scifi_nodes_glassstrng2.png",
			"scifi_nodes_glassstrngsd3.png",
		"scifi_nodes_glassstrngsd3.png"},
		type = "node",
		use_texture_alpha = "blend"})
