-- LUALOCALS < ---------------------------------------------------------
local math, minetest, nodecore
    = math, minetest, nodecore
local math_random
    = math.random
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local myapi = _G[modname]

local function reg(id, base, spot)
	myapi.maxcatid = ((not myapi.maxcatid) or (id > myapi.maxcatid)) and id or myapi.maxcatid
	local txr = "nc_cats_base.png^[multiply:" .. base .. ":255"
	if base ~= spot then
		txr = txr .. "^(nc_cats_spots.png^[multiply:" .. spot .. ":255)"
	end
	return minetest.register_node(modname .. ":cat_" .. id, {
			description = "Cat",
			tiles = {
				txr,
				txr .. "^nc_cats_paws.png",
				txr,
				txr,
				txr .. "^nc_cats_tail.png",
				txr .. "^nc_cats_face.png",
			},
			groups = {
				snappy = 1,
				falling_node = 1,
				[modname .. "_cat"] = 1
			},
			stack_max = 1,
			paramtype2 = "facedir",
			on_place = minetest.rotate_and_place,
			sounds = nodecore.sounds(modname .. "_mew"),
			preserve_metadata = function(_, _, oldmeta, drops)
				drops[1]:get_meta():from_table({fields = oldmeta})
			end,
			after_place_node = function(pos, _, itemstack)
				local meta = minetest.get_meta(pos)
				meta:from_table(itemstack:get_meta():to_table())
				myapi.setname(meta)
			end
		})
end

reg(1, "#c0c0c0", "#404040") -- light gray
reg(2, "#404040", "#202020") -- mid gray
reg(3, "#202020", "#101010") -- dark gray
reg(4, "#ff8000", "#804000") -- dark orange
reg(5, "#e0c040", "#ff8000") -- light orange
reg(6, "#804000", "#402000") -- dark brown
reg(7, "#c0a080", "#806020") -- light brown

nodecore.register_ambiance({
		label = modname .. " ambiance",
		nodenames = {"group:" .. modname .. "_cat"},
		interval = 5,
		chance = 5,
		sound_name = modname .. "_mew",
		sound_gain = 0.5
	})

function myapi.makecat(pos, param2)
	nodecore.set_loud(pos, {
			name = modname .. ":cat_" .. math_random(1, myapi.maxcatid),
			param2 = param2 or math_random(0, 3)
		})
	myapi.setname(minetest.get_meta(pos))
end
