-- LUALOCALS < ---------------------------------------------------------
local math, minetest, nodecore, pairs, vector
    = math, minetest, nodecore, pairs, vector
local math_random
    = math.random
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

local purrtimes = {
	1.676,
	1.617,
	1.642,
	1.655
}

local hashpos = minetest.hash_node_position
local purring = {}

local purrgain = 0.15

local function purr(pos)
	purring[hashpos(pos)] = true
	local id = math_random(1, #purrtimes)
	local fade = math_random(1, 10) == 1
	if not fade then
		local nearby
		for _, player in pairs(minetest.get_connected_players()) do
			if not nearby then
				local ppos = player:get_pos()
				ppos.y = ppos.y + player:get_properties().eye_height
				local diff = vector.subtract(pos, ppos)
				local dsqr = vector.dot(diff, diff)
				nearby = nearby or dsqr < 25
			end
		end
		fade = not nearby
	end
	local sh = nodecore.sound_play("nc_cats_purr_" .. id, {
			pos = pos,
			gain = purrgain,
			not_ephemeral = fade
		})
	if fade then
		minetest.sound_fade(sh, -purrgain / purrtimes[id], 0)
		return minetest.after(purrtimes[id], function()
				purring[hashpos(pos)] = nil
			end)
	else
		nodecore.dnt_set(pos, modname .. ":purr", purrtimes[id])
	end
end

nodecore.register_dnt({
		name = modname .. ":purr",
		nodenames = {"group:" .. modname .. "_cat"},
		action = purr
	})

local function notpurring(pos) return not purring[hashpos(pos)] and {} end

nodecore.register_craft({
		label = "pet cat",
		action = "pummel",
		toolgroups = {thumpy = 1},
		indexkeys = {"group:" .. modname .. "_cat"},
		check = notpurring,
		nodes = {
			{match = {
					groups = {[modname .. "_cat"] = true},
					stacked = false
			}}
		},
		after = purr
	})

nodecore.register_ambiance({
		label = modname .. " ambiance",
		nodenames = {"group:" .. modname .. "_cat"},
		interval = 5,
		chance = 5,
		check = notpurring,
		sound_name = modname .. "_mew",
		sound_gain = 0.5
	})
