-- LUALOCALS < ---------------------------------------------------------
local math, minetest, nodecore, pairs, string, vector
    = math, minetest, nodecore, pairs, string, vector
local math_abs, math_random, string_format
    = math.abs, math.random, string.format
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

local metakey = "catbreed"

minetest.register_abm({
		label = "cat breeding",
		nodenames = {"group:" .. modname .. "_cat"},
		interval = 5,
		chance = 1,
		action = function(pos)
			local found = #nodecore.find_nodes_around(pos,
				"group:" .. modname .. "_cat", 3)
			local meta = minetest.get_meta(pos)
			local qty = meta:get_float(metakey) or 0
			qty = qty + 2 ^ -math_abs(2 - found)
			meta:set_float(metakey, qty)
		end
	})

local purrtimes = {
	1.676,
	1.617,
	1.642,
	1.655
}

local hashpos = minetest.hash_node_position
local purring = {}

local purrgain = 0.15

local function purr(pos)
	purring[hashpos(pos)] = true

	local fade = math_random(1, 10) == 1
	if not fade then
		local nearby
		for _, player in pairs(minetest.get_connected_players()) do
			if not nearby then
				local ppos = player:get_pos()
				ppos.y = ppos.y + player:get_properties().eye_height
				local diff = vector.subtract(pos, ppos)
				local dsqr = vector.dot(diff, diff)
				nearby = nearby or dsqr < 25
			end
		end
		fade = not nearby
	end

	local id = math_random(1, #purrtimes)
	local sh = nodecore.sound_play("nc_cats_purr_" .. id, {
			pos = pos,
			gain = purrgain,
			not_ephemeral = fade
		})
	if fade then
		minetest.sound_fade(sh, -purrgain / purrtimes[id], 0)
		return minetest.after(purrtimes[id], function()
				purring[hashpos(pos)] = nil
			end)
	else
		nodecore.dnt_set(pos, modname .. ":purr", purrtimes[id])
	end
end

nodecore.register_dnt({
		name = modname .. ":purr",
		nodenames = {"group:" .. modname .. "_cat"},
		action = purr
	})

local function purrstart(pos)
	local meta = minetest.get_meta(pos)
	local qty = meta:get_float(metakey) or 0
	local roll = math_random(20, 2000)
	nodecore.log("action", string_format("cat at %s breed %0.2f, roll %d, %s",
			minetest.pos_to_string(pos), qty, roll,
			qty > roll and "success" or "failed"))
	if qty > roll then
		nodecore.item_eject(pos, modname .. ":prill", 5)
		nodecore.witness(pos, "cat eject prill")
	end
	meta:set_float(metakey, 0)

	return purr(pos)
end

local function notpurring(pos) return not purring[hashpos(pos)] and {} end

nodecore.register_craft({
		label = "pet cat",
		action = "pummel",
		toolgroups = {thumpy = 1},
		indexkeys = {"group:" .. modname .. "_cat"},
		check = notpurring,
		nodes = {
			{match = {
					groups = {[modname .. "_cat"] = true},
					stacked = false
			}}
		},
		after = purrstart
	})

nodecore.register_ambiance({
		label = modname .. " ambiance",
		nodenames = {"group:" .. modname .. "_cat"},
		interval = 5,
		chance = 5,
		check = notpurring,
		sound_name = modname .. "_mew",
		sound_gain = 0.5
	})
