-- LUALOCALS < ---------------------------------------------------------
local math, minetest, nodecore, pairs, vector
    = math, minetest, nodecore, pairs, vector
local math_abs, math_random
    = math.abs, math.random
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

local furmetakey = "catprill"

nodecore.register_soaking_abm({
		label = "cat furball",
		fieldname = "furball",
		nodenames = {"group:" .. modname .. "_cat"},
		interval = 5,
		arealoaded = 3,
		soakrate = function(pos)
			local meta = minetest.get_meta(pos)
			if meta:get_string(furmetakey) ~= "" then return false end

			local found = #nodecore.find_nodes_around(pos,
				"group:" .. modname .. "_cat", 3)
			return 2 ^ -math_abs(2 - found)
		end,
		soakcheck = function(data, pos)
			if data.total < 2000 then return end
			nodecore.log("action", "cat prill ready at " .. minetest.pos_to_string(pos))
			minetest.get_meta(pos):set_float(furmetakey, 1)
		end
	})

local purrtimes = {
	1.676,
	1.617,
	1.642,
	1.655
}

local hashpos = minetest.hash_node_position
local purring = {}

local purrgain = 0.15

local function purr(pos)
	purring[hashpos(pos)] = nodecore.gametime

	local fade = math_random(1, 10) == 1
	if not fade then
		local nearby
		for _, player in pairs(minetest.get_connected_players()) do
			if not nearby then
				local ppos = player:get_pos()
				ppos.y = ppos.y + player:get_properties().eye_height
				local diff = vector.subtract(pos, ppos)
				local dsqr = vector.dot(diff, diff)
				nearby = nearby or dsqr < 25
			end
		end
		fade = not nearby
	end

	local id = math_random(1, #purrtimes)
	local sh = nodecore.sound_play("nc_cats_purr_" .. id, {
			pos = pos,
			gain = purrgain,
			not_ephemeral = fade
		})
	if fade then
		minetest.sound_fade(sh, -purrgain / purrtimes[id], 0)
		return minetest.after(purrtimes[id], function()
				purring[hashpos(pos)] = nil
			end)
	else
		nodecore.dnt_set(pos, modname .. ":purr", purrtimes[id])
	end
end

nodecore.register_dnt({
		name = modname .. ":purr",
		nodenames = {"group:" .. modname .. "_cat"},
		action = purr
	})

local function purrstart(pos)
	local meta = minetest.get_meta(pos)
	local ready = meta:get_float(furmetakey) or 0
	if ready > 0 then
		nodecore.log("action", "cat ejects prill at " .. minetest.pos_to_string(pos))
		nodecore.item_eject(pos, modname .. ":prill", 5)
		nodecore.witness(pos, "cat eject prill")
		meta:set_float(furmetakey, 0)
	end
	return purr(pos)
end

local function notpurring(pos)
	local purrtime = purring[hashpos(pos)]
	if purrtime and purrtime < nodecore.gametime - 2 then
		purrtime = nil
		purring[hashpos(pos)] = nil
	end
	return not purrtime and {}
end

nodecore.register_craft({
		label = "pet cat",
		action = "pummel",
		toolgroups = {thumpy = 1},
		indexkeys = {"group:" .. modname .. "_cat"},
		check = notpurring,
		nodes = {
			{match = {
					groups = {[modname .. "_cat"] = true},
					stacked = false
			}}
		},
		after = purrstart
	})

nodecore.register_ambiance({
		label = modname .. " ambiance",
		nodenames = {"group:" .. modname .. "_cat"},
		interval = 5,
		chance = 5,
		check = notpurring,
		sound_name = modname .. "_mew",
		sound_gain = 0.5
	})
