-- LUALOCALS < ---------------------------------------------------------
local ipairs, minetest, string
    = ipairs, minetest, string
local string_gsub, string_lower
    = string.gsub, string.lower
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local myapi = _G[modname]

local function desc2name(s) return string_gsub(string_lower(s), "%W+", "_") end

local function reg(legacyid, desc, ...)
	myapi.register_cat_spots(desc, ...)
	local id = desc2name(desc)
	for _, n in ipairs({":cat_", ":longcat_front_", ":longcat_mid_", ":longcat_back_"}) do
		minetest.register_alias(modname .. n .. legacyid, modname .. n .. id)
	end
end
reg(1, "Light Gray", "#c0c0c0", "#404040")
reg(2, "Medium Gray", "#404040", "#202020")
reg(3, "Dark Gray", "#202020", "#101010")
reg(4, "Dark Orange", "#ff8000", "#804000")
reg(5, "Light Orange", "#e0c040", "#ff8000")
reg(6, "Dark Brown", "#804000", "#402000")
reg(7, "Light Brown", "#c0a080", "#806020")
