-- LUALOCALS < ---------------------------------------------------------
local minetest, nodecore, pairs, string
    = minetest, nodecore, pairs, string
local string_lower
    = string.lower
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

local function reg(name, pattern, color, material)
	local piecename = modname .. ":" .. string_lower(name .. "_" .. color)
	minetest.register_node(piecename, {
			description = color .. " " .. name,
			drawtype = "mesh",
			mesh = modname .. "_" .. string_lower(name) .. ".obj",
			selection_box = {
				type = "fixed",
				fixed = {-0.25, -0.5, -0.25, 0.25, 0.5, 0.25}
			},
			tiles = {
				minetest.registered_nodes["nc_concrete:" .. material].tiles[1]
				.. "^[colorize:#808080:32"
			},
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			groups = {
				snappy = 1,
				falling_node = 1,
				falling_repose = 1
			},
			sounds = nodecore.sounds("nc_terrain_stony"),
			on_construct = function(pos, node)
				node = node or minetest.get_node(pos)
				local r = pos.x + pos.y * 3 + pos.z * 7
				node.param2 = r % 4
				minetest.swap_node(pos, node)
			end
		})
	nodecore.register_craft({
			label = "chisel " .. string_lower(color) .. " " .. string_lower(name),
			action = "pummel",
			toolgroups = {thumpy = 3},
			normal = {y = 1},
			indexkeys = {"group:chisel"},
			nodes = {
				{
					match = {
						lode_temper_tempered = true,

						groups = {chisel = 2}
					},
					dig = true
				},
				{
					y = -1,
					match = "nc_concrete:concrete_" .. material
					.. "_" .. pattern,
					replace = piecename
				}
			}
		})
end

for name, pattern in pairs({
		Pawn = "bricky",
		Knight = "vermy",
		Bishop = "hashy",
		Rook = "boxy",
		Queen = "iceboxy",
		King = "bindy"
	}) do
	for color, material in pairs({
			White = "cloudstone",
			Black = "coalstone"
		}) do
		reg(name, pattern, color, material)
	end
end
