/*
 * Script to analyze an OBJ 3d model and rescale and recenter all vertices
 * so a naively exported model can be recentered and scaled to fit inside
 * e.g. a minetest node space.
 */

'use strict';

const fsp = require('fs').promises;
const path = require('path');

async function proc(fn) {
	const raw = (await fsp.readFile(fn)).toString();
	const lines = raw.split('\n');
	await fsp.writeFile(fn, lines
		.map(l => {
			if (!l.startsWith('vt ')) return l;
			const [x, y] = l.split(/\s+/).slice(1).map(x => Number(x));
			return `vt ${x * 2} ${y * 2}`;
		})
		.join('\n'));
}

fsp.readdir(__dirname)
	.then(async list => await Promise.all(list
		.filter(x => x.endsWith('.obj'))
		.map(async x => proc(path.join(__dirname, x)))));
