-- LUALOCALS < ---------------------------------------------------------
local ipairs, minetest, nodecore, pairs, string
    = ipairs, minetest, nodecore, pairs, string
local string_lower
    = string.lower
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

local chess_alias = {
	concrete_cloudstone = "white",
	concrete_coalstone = "black",
}

local function reg(name, basename, shape, pattern, basedef)
	local piecebase = modname .. ":" .. string_lower(shape) .. "_"
	local piecename = piecebase .. string_lower(name)
	if minetest.registered_nodes[piecename] then return end
	local desc = basedef.description or name
	minetest.register_node(piecename, {
			description = desc .. " " .. shape,
			drawtype = "mesh",
			mesh = modname .. "_" .. string_lower(shape) .. ".obj",
			selection_box = {
				type = "fixed",
				fixed = {-0.25, -0.5, -0.25, 0.25, 0.5, 0.25}
			},
			tiles = {
				basedef.tiles[1] .. "^[colorize:#808080:32"
			},
			paramtype = "light",
			paramtype2 = "facedir",
			groups = {
				snappy = 1,
				falling_node = 1,
				falling_repose = 1
			},
			sounds = basedef.sounds,
			on_construct = function(pos, node)
				node = node or minetest.get_node(pos)
				local r = pos.x + pos.y * 3 + pos.z * 7
				node.param2 = r % 4
				minetest.swap_node(pos, node)
			end
		})
	if chess_alias[name] then
		minetest.register_alias(piecebase .. chess_alias[name], piecename)
	end
	nodecore.register_craft({
			label = "chisel " .. string_lower(desc) .. " " .. string_lower(name),
			action = "pummel",
			toolgroups = {thumpy = 3},
			normal = {y = 1},
			indexkeys = {"group:chisel"},
			nodes = {
				{
					match = {
						lode_temper_tempered = true,
						groups = {chisel = 2}
					},
					dig = true
				},
				{
					y = -1,
					match = "nc_concrete:" .. name .. "_" .. pattern,
					replace = piecename
				}
			}
		})
end

local function buildall()
	for _, v in ipairs(nodecore.registered_concrete_etchables) do
		local basedef = v.name and v.basename and minetest.registered_nodes[v.basename]
		if basedef then
			for shape, pattern in pairs({
					Pawn = "bricky",
					Knight = "vermy",
					Bishop = "hashy",
					Rook = "boxy",
					Queen = "iceboxy",
					King = "bindy",
				}) do
				reg(v.name, v.basename, shape, pattern, basedef)
			end
		end
	end
end

do
	local old_reg_etch = nodecore.register_concrete_etchable
	local function helper(...)
		buildall()
		return ...
	end
	nodecore.register_concrete_etchable = function(...)
		return helper(old_reg_etch(...))
	end
end

buildall()
