-- LUALOCALS < ---------------------------------------------------------
local minetest, nodecore, os, pairs, tonumber, type, vector
    = minetest, nodecore, os, pairs, tonumber, type, vector
local os_time
    = os.time
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local exmachina = nodecore[modname]

minetest.mkdir(exmachina.path)

nodecore.register_dnt({
		name = modname,
		time = tonumber(minetest.settings:get(modname .. "_interval")) or 10,
		nodenames = {modname .. ":core"},
		loop = true,
		action = function(pos)
			local pname = minetest.get_meta(pos):get_string(modname)
			if (pname or "") == "" then return end

			local regpos = exmachina.location_get(pname)
			if not (regpos and vector.equals(pos, regpos)) then return end

			if not exmachina.arealoaded(pos) then return end

			local coremeta = minetest.get_meta(pos)
			if not exmachina.validate(pos) then
				coremeta:set_string("broken", "1")
				return
			end
			if coremeta:get_string("broken") ~= "" then
				coremeta:set_string("broken", "")
			end

			local pathbase = exmachina.pathbase(pname)
			local minpos, maxpos = exmachina.getbounds(pos)

			minetest.create_schematic(minpos, maxpos, nil, pathbase .. ".mts")

			coremeta:set_string("saved", minetest.serialize(os_time()))

			local allmeta = {}
			for _, p in pairs(minetest.find_nodes_with_meta(minpos, maxpos)) do
				local meta = minetest.get_meta(p):to_table()
				for _, v1 in pairs(meta.inventory or {}) do
					for k2, v2 in pairs(v1) do
						if type(v2) == "userdata" then
							v1[k2] = v2:to_string()
						end
					end
				end
				allmeta[vector.subtract(p, pos)] = meta
			end
			minetest.safe_file_write(
				pathbase .. ".meta",
				minetest.serialize(allmeta)
			)

			minetest.add_particlespawner({
					amount = 10,
					time = 1,
					minpos = vector.add(pos, {x = -0.5, y = 0.55, z = -0.5}),
					maxpos = vector.add(pos, {x = 0.5, y = 0.75, z = 0.5}),
					minacc = {x = -0.5, y = 1, z = -0.5},
					maxacc = {x = 0.5, y = 2, z = 0.5},
					minexptime = 2,
					maxexptime = 3,
					minsize = 1,
					maxsize = 2,
					collisiondetection = true,
					texture = exmachina.txr_puff
				})
		end
	})

minetest.register_abm({
		label = "Ex Machina Save",
		interval = tonumber(minetest.settings:get(modname .. "_interval")) or 10,
		chance = 1,
		nodenames = {modname .. ":core"},
		action = function(pos) nodecore.dnt_set(pos, modname) end
	})
nodecore.register_lbm({
		name = modname .. ":corednt",
		run_at_every_load = true,
		nodenames = {modname .. ":core"},
		action = function(pos) nodecore.dnt_set(pos, modname) end
	})
