-- LUALOCALS < ---------------------------------------------------------
local minetest, nodecore, pairs, type, vector
    = minetest, nodecore, pairs, type, vector
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local config = nodecore[modname]

local dxz = config.extent + 1
local dy = config.height + 1

local function arealoaded(pos)
	return minetest.get_node_or_nil(vector.add(pos, {x = -dxz, y = 0, z = -dxz}))
	and minetest.get_node_or_nil(vector.add(pos, {x = dxz, y = 0, z = -dxz}))
	and minetest.get_node_or_nil(vector.add(pos, {x = -dxz, y = 0, z = dxz}))
	and minetest.get_node_or_nil(vector.add(pos, {x = dxz, y = 0, z = dxz}))
	and minetest.get_node_or_nil(vector.add(pos, {x = -dxz, y = dy, z = -dxz}))
	and minetest.get_node_or_nil(vector.add(pos, {x = dxz, y = dy, z = -dxz}))
	and minetest.get_node_or_nil(vector.add(pos, {x = -dxz, y = dy, z = dxz}))
	and minetest.get_node_or_nil(vector.add(pos, {x = dxz, y = dy, z = dxz}))
end

minetest.mkdir(config.path)

nodecore.register_limited_abm({
		label = "Ex Machina Save",
		interval = 5,
		chance = 1,
		nodenames = {modname .. ":core"},
		action = function(pos)
			if not arealoaded(pos) then return end

			local pname = minetest.get_meta(pos):get_string(modname)
			if (pname or "") == "" then return end

			local pathbase = config.path .. "/" .. pname:gsub("%W", "")
			.. "_" .. minetest.sha1(pname)

			local minpos = vector.add(pos, {x = -dxz, y = 0, z = -dxz})
			local maxpos = vector.add(pos, {x = dxz, y = dy, z = dxz})

			minetest.create_schematic(minpos, maxpos, nil, pathbase .. ".mts")

			local allmeta = {}
			for _, p in pairs(minetest.find_nodes_with_meta(minpos, maxpos)) do
				local meta = minetest.get_meta(p):to_table()
				for _, v1 in pairs(meta.inventory or {}) do
					for k2, v2 in pairs(v1) do
						if type(v2) == "userdata" then
							v1[k2] = v2:to_string()
						end
					end
				end
				allmeta[vector.subtract(p, pos)] = meta
			end
			minetest.safe_file_write(
				pathbase .. ".meta",
				minetest.serialize(allmeta)
			)

			minetest.add_particlespawner({
					amount = 10,
					time = 1,
					minpos = vector.add(pos, {x = -0.5, y = 0.55, z = -0.5}),
					maxpos = vector.add(pos, {x = 0.5, y = 0.75, z = 0.5}),
					minacc = {x = -0.5, y = 1, z = -0.5},
					maxacc = {x = 0.5, y = 2, z = 0.5},
					minexptime = 2,
					maxexptime = 3,
					minsize = 1,
					maxsize = 2,
					collisiondetection = true,
					texture = modname .. "_puff.png"
				})
		end
	})
