-- LUALOCALS < ---------------------------------------------------------
local io, ipairs, minetest, nodecore, pairs, vector
    = io, ipairs, minetest, nodecore, pairs, vector
local io_open
    = io.open
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local config = nodecore[modname]

minetest.register_privilege(modname, "Can summon Dais Ex Machina")

local dxz = config.extent + 1

local craftnodes = {}
local craftair = {}
for y = 0, config.height + 1 do
	for x = -dxz, dxz do
		for z = -dxz, dxz do
			if y == 0 and (z == 0 or x == 0) then
				craftnodes[#craftnodes + 1] = {
					x = x, y = y, z = z,
					match = "nc_tree:eggcorn",
					replace = "air"
				}
			else
				craftair[#craftair + 1] = {
					x = x, y = y, z = z,
					match = "air"
				}
			end
		end
	end
end
for _, v in ipairs(craftair) do craftnodes[#craftnodes + 1] = v end

nodecore.register_craft({
		label = "summon dais ex machina",
		action = "pummel",
		duration = 4,
		wield = {name = "nc_tree:eggcorn", count = false},
		check = function(_, data)
			return minetest.check_player_privs(data.crafter, {[modname] = true})
			and (data.crafter:get_meta():get_string(modname) or "") == ""
		end,
		nodes = craftnodes,
		after = function(pos, data)
			local pname = data.pname or data.crafter:get_player_name()

			local pathbase = config.path .. "/" .. pname:gsub("%W", "")
			.. "_" .. minetest.sha1(pname)

			local path = pathbase .. ".mts"
			local spos = vector.subtract(pos, {x = dxz, y = 0, z = dxz})
			local f = io_open(path, "rb")
			if f then
				f:close()
				minetest.place_schematic(spos, path)
			else
				minetest.place_schematic(spos, config.schematic)
			end

			path = pathbase .. ".meta"
			f = io_open(path, "rb")
			if f then
				local s = f:read("*all")
				f:close()
				s = minetest.deserialize(s)
				for k, v in pairs(s) do
					minetest.get_meta(vector.add(pos, k)):from_table(v)
				end
			end

			minetest.get_meta(pos):set_string(modname, pname)
			return data.crafter:get_meta():set_string(modname, minetest.pos_to_string(pos))
		end
	})
