-- LUALOCALS < ---------------------------------------------------------
local io, ipairs, minetest, nodecore, pairs, vector
    = io, ipairs, minetest, nodecore, pairs, vector
local io_open
    = io.open
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local config = nodecore[modname]

minetest.register_privilege(modname, "Can summon Dais Ex Machina")

local dxz = config.extent + 1

local craftnodes = {}
local craftair = {}
for y = 0, config.height + 1 do
	for x = -dxz, dxz do
		for z = -dxz, dxz do
			if y == 0 and (z == 0 or x == 0) then
				craftnodes[#craftnodes + 1] = {
					x = x, y = y, z = z,
					match = "nc_tree:eggcorn",
					replace = "air"
				}
			else
				craftair[#craftair + 1] = {
					x = x, y = y, z = z,
					match = "air"
				}
			end
		end
	end
end
for _, v in ipairs(craftair) do craftnodes[#craftnodes + 1] = v end

local function areapuffs(pos, qty, time)
	return minetest.add_particlespawner({
			amount = qty,
			time = time,
			minpos = {
				x = pos.x - dxz - 0.5,
				y = pos.y - 0.5,
				z = pos.z - dxz - 0.5
			},
			maxpos = {
				x = pos.x + dxz + 0.5,
				y = pos.y + config.height + 1.5,
				z = pos.z + dxz + 0.5
			},
			minvel = {x = -0.2, y = -0.2, z = -0.2},
			maxvel = {x = 0.2, y = 0.2, z = 0.2},
			minexptime = 1,
			maxexptime = 2,
			texture = modname .. "_puff.png",
			glow = 2
		})
end

nodecore.register_craft({
		label = "summon dais ex machina",
		action = "pummel",
		duration = 4,
		wield = {name = "nc_tree:eggcorn", count = false},
		check = function(_, data)
			return minetest.check_player_privs(data.crafter, {[modname] = true})
			and (data.crafter:get_meta():get_string(modname) or "") == ""
		end,
		nodes = craftnodes,
		after = function(pos, data)
			local pname = data.pname or data.crafter:get_player_name()

			local spos = vector.subtract(pos, {x = dxz, y = 0, z = dxz})
			minetest.place_schematic(spos, config.summoning)
			minetest.get_meta(pos):set_string(modname, pname)
			data.crafter:get_meta():set_string(modname, minetest.pos_to_string(pos))

			return areapuffs(pos, 250, 0.01)
		end
	})

minetest.register_abm({
		label = "Dais Ex Machina Summoning Completion",
		interval = 1,
		chance = 1,
		nodenames = {modname .. ":nexus"},
		action = function(pos)
			for _, player in pairs(minetest.get_connected_players()) do
				if nodecore.interact(player) then
					local pp = player:get_pos()
					if (pp.x > pos.x - dxz - 1)
					and (pp.x < pos.x + dxz + 1)
					and (pp.z > pos.z - dxz - 1)
					and (pp.z < pos.z + dxz + 1)
					and (pp.y > pos.y - 2.5)
					and (pp.y < pos.y + config.height + 1.5) then
						return areapuffs(pos, 25, 1)
					end
				end
			end
			local pname = minetest.get_meta(pos):get_string(modname)

			local pathbase = config.path .. "/" .. pname:gsub("%W", "")
			.. "_" .. minetest.sha1(pname)

			local path = pathbase .. ".mts"
			local spos = vector.subtract(pos, {x = dxz, y = 0, z = dxz})
			local f = io_open(path, "rb")
			if f then
				f:close()
				minetest.place_schematic(spos, path)
			else
				minetest.place_schematic(spos, config.schematic)
			end

			path = pathbase .. ".meta"
			f = io_open(path, "rb")
			if f then
				local s = f:read("*all")
				f:close()
				s = minetest.deserialize(s)
				for k, v in pairs(s) do
					minetest.get_meta(vector.add(pos, k)):from_table(v)
				end
			end

			minetest.get_meta(pos):set_string(modname, pname)
			return areapuffs(pos, 250, 0.01)
		end
	})
