-- LUALOCALS < ---------------------------------------------------------
local minetest, nodecore, table
    = minetest, nodecore, table
local table_concat
    = table.concat
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local exmachina = nodecore[modname]

local function expandify(q, e, m, c)
	local t = {e}
	for _ = 1, q do t[#t + 1] = m end
	t[#t + 1] = c or m
	for _ = 1, q do t[#t + 1] = m end
	t[#t + 1] = e
	return t
end

local fffff = table_concat(expandify(exmachina.extent, "f", "f"))
local fcfcf = table_concat(expandify(exmachina.extent, "f", "c", "f"))
local ffxff = table_concat(expandify(exmachina.extent, "f", "f", "x"))
local f___f = table_concat(expandify(exmachina.extent, "f", "_"))
local empty = table_concat(expandify(exmachina.extent, "_", "_"))

local top = expandify(exmachina.extent, fffff, f___f)
local bot = expandify(exmachina.extent, fffff, fcfcf, ffxff)
local mid = expandify(exmachina.extent, f___f, empty)

local full = {bot}
for _ = 1, exmachina.height do full[#full + 1] = mid end
full[#full + 1] = top

exmachina.schematic_final = nodecore.ezschematic(
	{
		_ = {name = "air", prob = 255},
		c = {name = "nc_terrain:cobble", prob = 255},
		x = {name = modname .. ":core", prob = 255},
		f = {name = modname .. ":frame", prob = 255},
	},
	full
)

exmachina.schematic_trans = nodecore.ezschematic(
	{
		_ = {name = modname .. ":field", prob = 255},
		c = {name = modname .. ":field", prob = 255},
		x = {name = modname .. ":nexus", prob = 255},
		f = {name = modname .. ":field", prob = 255},
	},
	full
)

exmachina.schematic_banish = nodecore.ezschematic(
	{
		_ = {name = "air", prob = 255},
		c = {name = "air", prob = 255},
		x = {name = "air", prob = 255},
		f = {name = "air", prob = 255},
	},
	full
)
