-- LUALOCALS < ---------------------------------------------------------
local ipairs, minetest, nodecore
    = ipairs, minetest, nodecore
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local exmachina = nodecore[modname]

minetest.register_privilege(modname, "Can summon Dais Ex Machina")

local dxz = exmachina.extent + 1

local craftnodes = {}
local craftair = {}
for y = 0, exmachina.height + 1 do
	for x = -dxz, dxz do
		for z = -dxz, dxz do
			if y == 0 and (z == 0 or x == 0) then
				craftnodes[#craftnodes + 1] = {
					x = x, y = y, z = z,
					match = "nc_tree:eggcorn",
					replace = "air"
				}
			else
				craftair[#craftair + 1] = {
					x = x, y = y, z = z,
					match = "air"
				}
			end
		end
	end
end
for _, v in ipairs(craftair) do craftnodes[#craftnodes + 1] = v end

nodecore.register_craft({
		label = "summon dais ex machina",
		action = "pummel",
		duration = 4,
		wield = {name = "nc_tree:eggcorn", count = false},
		check = function(_, data)
			return minetest.check_player_privs(data.crafter, {[modname] = true})
			and (not exmachina.location_get(data.crafter))
		end,
		nodes = craftnodes,
		after = function(pos, data)
			local pname = data.pname or data.crafter:get_player_name()
			return exmachina.summon_start(pos, pname)
		end
	})

minetest.register_abm({
		label = "Dais Ex Machina Summoning Completion",
		interval = 1,
		chance = 1,
		nodenames = {modname .. ":nexus"},
		action = function(pos)
			if exmachina.summon_occupied(pos) then
				return exmachina.areapuffs(pos, 25, 1)
			end
			local pname = minetest.get_meta(pos):get_string(modname)
			return exmachina.summon_complete(pos, pname)
		end
	})
