-- LUALOCALS < ---------------------------------------------------------
local minetest, nodecore
    = minetest, nodecore
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local exmachina = nodecore[modname]

local coredesc ="Dais Ex Machina Core"
minetest.register_node(modname .. ":core", {
		description = coredesc,
		tiles = {
			exmachina.txr_core,
			exmachina.txr_core,
			exmachina.txr_frame
		},
		on_node_touchtip = function(pos)
			local owner = minetest.get_meta(pos):get_string(modname)
			if owner and owner ~= "" then
				return coredesc .. "\n" .. owner
			end
		end,
		sounds = nodecore.sounds("nc_terrain_stony")
	})

minetest.register_node(modname .. ":frame", {
		description = "Dais Ex Machina Frame",
		tiles = {exmachina.txr_frame},
		sounds = nodecore.sounds("nc_terrain_stony")
	})

minetest.register_node(modname .. ":field", {
		drawtype = "allfaces",
		tiles = {{
				name = exmachina.txr_sparkle,
				backface_culling = false
		}},
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false,
		pointable = false,
		climbable = true,
	})

minetest.register_node(modname .. ":nexus", {
		drawtype = "allfaces",
		tiles = {{
				name = exmachina.txr_sparkle,
				backface_culling = false
		}},
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false,
		pointable = false,
		climbable = true,
	})
