-- LUALOCALS < ---------------------------------------------------------
local ipairs, minetest, nodecore, table
    = ipairs, minetest, nodecore, table
local table_concat
    = table.concat
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local exmachina = nodecore[modname]

local function expandify(q, e, m, c)
	local t = {e}
	for _ = 1, q do t[#t + 1] = m end
	t[#t + 1] = c or m
	for _ = 1, q do t[#t + 1] = m end
	t[#t + 1] = e
	return t
end

local fffff = table_concat(expandify(exmachina.extent, "f", "f"))
local ffeff = table_concat(expandify(exmachina.extent, "f", "f", "e"))
local fcecf = table_concat(expandify(exmachina.extent, "f", "c", "e"))
local eexee = table_concat(expandify(exmachina.extent, "e", "e", "x"))
local f___f = table_concat(expandify(exmachina.extent, "f", "_"))
local empty = table_concat(expandify(exmachina.extent, "_", "_"))

local top = expandify(exmachina.extent, fffff, f___f)
local bot = expandify(exmachina.extent, ffeff, fcecf, eexee)
local mid = expandify(exmachina.extent, f___f, empty)

local full = {bot}
for _ = 1, exmachina.height do full[#full + 1] = mid end
full[#full + 1] = top

exmachina.schematic_final = nodecore.ezschematic(
	{
		_ = {name = "air", prob = 255},
		c = {name = "nc_terrain:cobble", prob = 255},
		x = {name = modname .. ":core", prob = 255},
		f = {name = modname .. ":frame", prob = 255},
		e = {name = modname .. ":frame", prob = 255},
	},
	full
)

exmachina.schematic_trans = nodecore.ezschematic(
	{
		_ = {name = modname .. ":field", prob = 255},
		c = {name = modname .. ":field", prob = 255},
		x = {name = modname .. ":nexus", prob = 255},
		f = {name = modname .. ":field", prob = 255},
		e = {name = modname .. ":field", prob = 255},
	},
	full
)

exmachina.schematic_banish = nodecore.ezschematic(
	{
		_ = {name = "air", prob = 255},
		c = {name = "air", prob = 255},
		x = {name = "air", prob = 255},
		f = {name = "air", prob = 255},
		e = {name = "air", prob = 255},
	},
	full
)

local function mkcraftnodes(key)
	local data = {}
	for y, ys in ipairs(full) do
		for z, zs in ipairs(ys) do
			for x = 1, zs:len() do
				data[#data + 1] = {
					x = x - exmachina.extent - 2,
					y = y - 1,
					z = z - exmachina.extent - 2,
					match = key[zs:sub(x, x)]
				}
			end
		end
	end
	return data
end

local aireq = {air_equivalent = true}

exmachina.craftnodes_summon = mkcraftnodes({
		_ = aireq,
		c = aireq,
		x = "nc_tree:eggcorn",
		f = aireq,
		e = "nc_tree:eggcorn",
	})

exmachina.craftnodes_banish = mkcraftnodes({
		_ = aireq,
		c = "nc_terrain:cobble",
		x = modname .. ":core",
		f = modname .. ":frame",
		e = modname .. ":frame",
	})
