-- LUALOCALS < ---------------------------------------------------------
local io, math, minetest, nodecore, pairs, tonumber, type, vector
    = io, math, minetest, nodecore, pairs, tonumber, type, vector
local io_open, math_floor
    = io.open, math.floor
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local modstore = minetest.get_mod_storage()

local function getsetting(n, v)
	return tonumber(minetest.settings:get(modname .. "_" .. n)) or v
end
local exmachina = {
	path = minetest.get_worldpath() .. "/" .. modname,
	extent = math_floor(getsetting("extent", 3)),
	height = math_floor(getsetting("height", 3)),
}
nodecore[modname] = exmachina

exmachina.txr_puff = modname .. "_pattern.png^[mask:" .. modname .. "_mask.png"
exmachina.txr_frame = "nc_terrain_stone.png^(" .. modname .. "_pattern.png^[opacity:32)"
exmachina.txr_core = exmachina.txr_frame .. "^(" .. exmachina.txr_puff .. "^[opacity:128])"
exmachina.txr_sparkle = modname .. "_sparkle.png"

minetest.mkdir(exmachina.path)

local function getplayer(pspec)
	if type(pspec) == "userdata" then
		return pspec, pspec:get_player_name()
	end
	return minetest.get_player_by_name(pspec), pspec
end

function exmachina.location_get(pspec)
	local player, pname = getplayer(pspec)
	local pos = modstore:get_string(pname)
	if pos == "X" then return end
	if pos and pos ~= "" then return minetest.string_to_pos(pos) end
	if not player then return end
	pos = player:get_meta():get_string(modname)
	if pos and pos ~= "" then
		modstore:set_string(pname, pos)
		return minetest.string_to_pos(pos)
	end
end

function exmachina.location_set(pspec, pos)
	local _, pname = getplayer(pspec)
	pos = pos and minetest.pos_to_string(pos) or "X"
	modstore:set_string(pname, pos)
end

minetest.register_on_joinplayer(function(player)
		-- Automatically migrate legacy data.
		return exmachina.location_get(player)
	end)

local dxz = exmachina.extent + 1
local dy = exmachina.height + 1
function exmachina.getbounds(pos, margin)
	margin = margin or 0
	return {
		x = pos.x - dxz - margin,
		y = pos.y - margin,
		z = pos.z - dxz - margin
		}, {
		x = pos.x + dxz + margin,
		y = pos.y + dy + margin,
		z = pos.z + dxz + margin
	}
end

function exmachina.areapuffs(pos, qty, time)
	local minpos, maxpos = exmachina.getbounds(pos, 0.5)
	return minetest.add_particlespawner({
			amount = qty,
			time = time,
			minpos = minpos,
			maxpos = maxpos,
			minvel = {x = -0.2, y = -0.2, z = -0.2},
			maxvel = {x = 0.2, y = 0.2, z = 0.2},
			minexptime = 1,
			maxexptime = 2,
			texture = exmachina.txr_puff,
			glow = 2
		})
end

function exmachina.fallcheck(pos)
	local minpos, maxpos = exmachina.getbounds(pos)
	for _, p in pairs(minetest.find_nodes_in_area(minpos,
			maxpos, "group:falling_node")) do
		nodecore.fallcheck(p)
	end
end

function exmachina.summon_start(pos, pname)
	local minpos = exmachina.getbounds(pos)
	minetest.place_schematic(minpos, exmachina.schematic_trans)
	minetest.get_meta(pos):set_string(modname, pname)
	exmachina.location_set(pname, pos)
	return exmachina.areapuffs(pos, 250, 0.01)
end

function exmachina.summon_occupied(pos)
	local minpos, maxpos = exmachina.getbounds(pos, 1)
	for _, player in pairs(minetest.get_connected_players()) do
		if nodecore.interact(player) then
			local pp = player:get_pos()
			if (pp.x > minpos.x)
			and (pp.x < maxpos.x)
			and (pp.z > minpos.z)
			and (pp.z < maxpos.z)
			and (pp.y > minpos.y - 1)
			and (pp.y < maxpos.y) then
				return player
			end
		end
	end
end

function exmachina.pathbase(pname)
	return exmachina.path .. "/" .. pname:gsub("%W", "")
	.. "_" .. minetest.sha1(pname)
end

function exmachina.summon_complete(pos, pname)
	local pathbase = exmachina.pathbase(pname)

	local minpos, maxpos = exmachina.getbounds(pos)
	local path = pathbase .. ".mts"
	local f = io_open(path, "rb")
	if f then
		f:close()
		minetest.place_schematic(minpos, path)
	else
		minetest.place_schematic(minpos, exmachina.schematic_final)
	end

	path = pathbase .. ".meta"
	f = io_open(path, "rb")
	if f then
		local s = f:read("*all")
		f:close()
		s = minetest.deserialize(s)
		for k, v in pairs(s) do
			minetest.get_meta(vector.add(pos, k)):from_table(v)
		end
	end
	minetest.get_meta(pos):set_string(modname, pname)

	local found = minetest.find_nodes_in_area(minpos, maxpos, "group:visinv")
	for _, p in pairs(found) do nodecore.visinv_update_ents(p) end

	exmachina.location_set(pname, pos)
	exmachina.fallcheck(pos)
	return exmachina.areapuffs(pos, 250, 0.01)
end

function exmachina.banish(pos, pname)
	local minpos, maxpos = exmachina.getbounds(pos)
	local found = minetest.find_nodes_in_area(minpos, maxpos, "group:visinv")
	minetest.place_schematic(minpos, exmachina.schematic_banish)
	for _, p in pairs(found) do nodecore.visinv_update_ents(p) end
	exmachina.location_set(pname)
	exmachina.fallcheck(pos)
	return exmachina.areapuffs(pos, 250, 0.01)
end

function exmachina.arealoaded(pos)
	return minetest.get_node_or_nil(vector.add(pos, {x = -dxz, y = 0, z = -dxz}))
	and minetest.get_node_or_nil(vector.add(pos, {x = dxz, y = 0, z = -dxz}))
	and minetest.get_node_or_nil(vector.add(pos, {x = -dxz, y = 0, z = dxz}))
	and minetest.get_node_or_nil(vector.add(pos, {x = dxz, y = 0, z = dxz}))
	and minetest.get_node_or_nil(vector.add(pos, {x = -dxz, y = dy, z = -dxz}))
	and minetest.get_node_or_nil(vector.add(pos, {x = dxz, y = dy, z = -dxz}))
	and minetest.get_node_or_nil(vector.add(pos, {x = -dxz, y = dy, z = dxz}))
	and minetest.get_node_or_nil(vector.add(pos, {x = dxz, y = dy, z = dxz}))
end
