-- LUALOCALS < ---------------------------------------------------------
local minetest, nodecore, pairs
    = minetest, nodecore, pairs
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local exmachina = nodecore[modname]

local modstore = minetest.get_mod_storage()

local old_prot = minetest.is_protected

local grouppref = "group:"
local function match(nodename)
	for _, s in pairs((minetest.settings:get(modname .. "_protect") or "group:metal_cube")
		:split()) do
		if (s:sub(1, #grouppref) == grouppref) then
			if minetest.get_item_group(nodename, s:sub(#grouppref + 1)) > 0 then
				return true
			end
		else
			if nodename == s then return true end
		end
	end
end

local function owner(pos)
	for k, v in pairs(modstore:to_table().fields) do
		local min, max = exmachina.getbounds(minetest.string_to_pos(v), 0.5)
		if pos.x >= min.x and pos.x <= max.x
		and pos.y >= min.y and pos.y <= max.y
		and pos.z >= min.z and pos.z <= max.z then return k end
	end
end

local function check(pos, thingname, pname)
	if minetest.check_player_privs(pname, "protection_bypass") then return end
	if match(thingname) then
		local owned = owner(pos)
		if owned and owned ~= pname then return true end
	end
end
function minetest.is_protected(pos, name, ...)
	if check(pos, minetest.get_node(pos).name, name) then return true end
	return old_prot(pos, name, ...)
end

local old_place = minetest.item_place_node
function minetest.item_place_node(itemstack, placer, pointed_thing, ...)
	local pos = nodecore.buildable_to(pointed_thing.under)
	and pointed_thing.under or pointed_thing.above
	local name = placer and placer:is_player() and placer:get_player_name()
	if pos and name and check(pos, itemstack:get_name(), name) then return itemstack end
	return old_place(itemstack, placer, pointed_thing, ...)
end
