-- LUALOCALS < ---------------------------------------------------------
local minetest, nodecore, pairs, rawset
    = minetest, nodecore, pairs, rawset
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local exmachina = nodecore[modname]

local old_prot = minetest.is_protected

local default = "group:metal_cube, group:tote"

local grouppref = "group:"
local function match(nodename)
	for _, s in pairs((minetest.settings:get(modname .. "_protect") or default)
		:split()) do
		s = s:trim()
		if (s:sub(1, #grouppref) == grouppref) then
			if minetest.get_item_group(nodename, s:sub(#grouppref + 1)) > 0 then
				return true
			end
		else
			if nodename == s then return true end
		end
	end
end

local function owner(pos)
	for k, v in pairs(exmachina.store:to_table().fields) do
		local min, max = exmachina.getbounds(minetest.string_to_pos(v), 0.5)
		if pos.x >= min.x and pos.x <= max.x
		and pos.y >= min.y and pos.y <= max.y
		and pos.z >= min.z and pos.z <= max.z then return k end
	end
end

local function check(pos, thingname, pname)
	if minetest.check_player_privs(pname, "protection_bypass") then return end
	if match(thingname) then
		local owned = owner(pos)
		if owned and owned ~= pname then return true end
	end
end

local placing

-- Check on trying to dig/access a protected node, and
-- handle placement check from special cases.
function minetest.is_protected(pos, name, ...)
	if check(pos, minetest.get_node(pos).name, name)
	or (placing and check(pos, placing, name)) then return true end
	return old_prot(pos, name, ...)
end

-- Check on trying to place a protected node.
local old_place = minetest.item_place_node
function minetest.item_place_node(itemstack, placer, pointed_thing, ...)
	local pos = nodecore.buildable_to(pointed_thing.under)
	and pointed_thing.under or pointed_thing.above
	local name = placer and placer:is_player() and placer:get_player_name()
	if pos and name and check(pos, itemstack:get_name(), name) then return itemstack end
	return old_place(itemstack, placer, pointed_thing, ...)
end

-- Search for special-case nodes like totes that have custom place logic.
local function placedone(...) placing = nil return ... end
local function checkdef(name, def)
	minetest.log(name)
	if not (def.on_place and match(name)) then return end
	minetest.log("MATCH!!!!!")
	local oldp = def.on_place
	rawset(def, "on_place", function(...)
			placing = name
			return placedone(oldp(...))
		end)
end
minetest.after(0, function()
		for k, v in pairs(minetest.registered_nodes) do
			checkdef(k, v)
		end
	end)
