-- LUALOCALS < ---------------------------------------------------------
local math, tonumber
    = math, tonumber
local math_floor
    = math.floor
-- LUALOCALS > ---------------------------------------------------------

local stamp = tonumber("$Format:%at$")
if not stamp then return end
stamp = math_floor((stamp - 1540612800) / 60)
stamp = ("00000000" .. stamp):sub(-8)

-- luacheck: push
-- luacheck: globals config readtext readbinary

readtext = readtext or function() end
readbinary = readbinary or function() end

return {
	user = "Warr1024",
	pkg = "nc_exmachina",
	min = "5.0",
	version = stamp .. "-$Format:%h$",
	path = ".",
	type = "mod",
	title = "Dais Ex Machina",
	short_desc = "An other-worldly platform to preserve some of your stuff across map resets for NodeCore",
	tags = "building, inventory, transport, maintenance, machines",
	license = "mit",
	desc = readtext('README.md'),
	repo = "https://gitlab.com/sztest/nc_exmachina",
	issueTracker = "https://discord.gg/NNYeF6f",
	screenshots = {
		readbinary('.cdb-screenshot.jpg')
	}
}

-- luacheck: pop
