-- LUALOCALS < ---------------------------------------------------------
local minetest, nodecore
    = minetest, nodecore
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

minetest.register_craftitem(modname .. ":plant_fibers", {
		description = ("Plant Fibers"),
		inventory_image = modname .. "_plant_fibers.png",
		wield_image = modname .. "_plant_fibers.png",
		groups = {snappy = 1, flammable = 1},
		sounds = nodecore.sounds("nc_terrain_swishy"),
	})

nodecore.register_craft({
		label = "grind plants into fibers",
		action = "pummel",
		toolgroups = {crumbly = 2},
		nodes = {
			{
				match = {stacked = true, groups = {flora_dry = true}, count = false}
			}
		},
		after = function(pos)
			local stack = nodecore.stack_get(pos)
			stack:set_name(modname .. ":plant_fibers")
			nodecore.stack_set(pos, stack)
		end
	})

nodecore.register_craft({
		label = "grind plant fibers to peat",
		action = "pummel",
		toolgroups = {crumbly = 2},
		nodes = {
			{
				match = {name = modname .. ":plant_fibers", count = 8},
				replace = "nc_tree:peat"
			}
		}
	})
