-- LUALOCALS < ---------------------------------------------------------
local math, minetest, nodecore
    = math, minetest, nodecore
local math_random
    = math.random
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

nodecore.register_limited_abm({
		label = "shrubs spreading",
		nodenames = {modname .. ":shrub"},
		-- neighbors = {"air"},
		interval = 120,
		chance = 20,
		action = function(pos)
			local gro = {x = pos.x + math_random(-1, 1), y = pos.y + math_random(-1, 1), z = pos.z + math_random(-1, 1)}
			local grodown = {x = gro.x, y = gro.y - 1, z = gro.z}
			local num = minetest.find_nodes_in_area(
				{x = pos.x + 1, y = pos.y - 1, z = pos.z + 1},
				{x = pos.x - 1, y = pos.y - 1, z = pos.z - 1},
				{"nc_tree:humus", "nc_terrain:dirt"})
			if minetest.get_node(gro).name ~= "air" then return end
			if minetest.get_node(grodown).name ~= {"nc_tree:humus", "nc_terrain:dirt"} then return end
			if #num > 0 then
				nodecore.set_node(gro, {name = modname .. ":shrub"})
			end
		end,
	})

nodecore.register_limited_abm({
		label = "ferns spreading",
		nodenames = {modname .. ":fern"},
		-- neighbors = {"air"},
		interval = 120,
		chance = 20,
		action = function(pos)
			local gro = {x = pos.x + math_random(-1, 1), y = pos.y + math_random(-1, 1), z = pos.z + math_random(-1, 1)}
			local grodown = {x = gro.x, y = gro.y - 1, z = gro.z}
			local num = minetest.find_nodes_in_area(
				{x = pos.x + 1, y = pos.y - 1, z = pos.z + 1},
				{x = pos.x - 1, y = pos.y - 1, z = pos.z - 1},
				{"nc_tree:humus", "nc_terrain:dirt"})
			if minetest.get_node(gro).name ~= "air" then return end
			if minetest.get_node(grodown).name ~= {"nc_tree:humus", "nc_terrain:dirt"} then return end
			if #num > 0 then
				nodecore.set_node(gro, {name = modname .. ":fern"})
			end
		end,
	})

nodecore.register_limited_abm({
		label = "thornbriar spreading",
		nodenames = {modname .. ":thornbriar"},
		-- neighbors = {"air"},
		interval = 120,
		chance = 20,
		action = function(pos)
			local gro = {x = pos.x + math_random(-1, 1), y = pos.y + math_random(-1, 1), z = pos.z + math_random(-1, 1)}
			local grodown = {x = gro.x, y = gro.y - 1, z = gro.z}
			local num = minetest.find_nodes_in_area(
				{x = pos.x + 1, y = pos.y - 1, z = pos.z + 1},
				{x = pos.x - 1, y = pos.y - 1, z = pos.z - 1},
				{"nc_tree:humus", "nc_terrain:dirt"})
			if minetest.get_node(gro).name ~= "air" then return end
			if minetest.get_node(grodown).name ~= {"nc_tree:humus", "nc_terrain:dirt"} then return end
			if #num > 0 and pos.y < 50 then
				nodecore.set_node(gro, {name = modname .. ":thornbriar"})
			end
		end,
	})

nodecore.register_limited_abm({
		label = "lilypads spreading",
		nodenames = {modname .. ":lilypad"},
		neighbors = {"group:water"},
		interval = 120,
		chance = 20,
		action = function(pos)
			local gro = {x = pos.x + math_random(-1, 1), y = pos.y + math_random(-1, 1), z = pos.z + math_random(-1, 1)}
			local grodown = {x = gro.x, y = gro.y - 1, z = gro.z}
			local num = minetest.find_nodes_in_area(
				{x = pos.x + 1, y = pos.y - 1, z = pos.z + 1},
				{x = pos.x - 1, y = pos.y - 1, z = pos.z - 1},
				{"nc_terrain:water_source"})
			local dname = minetest.get_node(grodown).name
			if minetest.get_node(gro).name ~= "air" then return end
			if minetest.get_item_group(dname, "water") > 0 then return end
			if #num > 3 and pos.y < 5 then
				nodecore.set_node(gro, {name = modname .. ":lilypad"})
			end
		end,
	})

nodecore.register_limited_abm({
		label = "mushroom spreading",
		nodenames = {modname .. ":mushroom"},
		-- neighbors = {"air"},
		interval = 120,
		chance = 20,
		action = function(pos)
			local gro = {x = pos.x + math_random(-1, 1), y = pos.y + math_random(-1, 1), z = pos.z + math_random(-1, 1)}
			local grodown = {x = gro.x, y = gro.y - 1, z = gro.z}
			local num = minetest.find_nodes_in_area(
				{x = pos.x + 1, y = pos.y - 1, z = pos.z + 1},
				{x = pos.x - 1, y = pos.y - 1, z = pos.z - 1},
				{"nc_tree:humus", "nc_terrain:dirt"})
			if minetest.get_node(gro).name ~= "air" then return end
			if minetest.get_node(grodown).name ~= {"nc_tree:humus", "nc_terrain:dirt"} then return end
			if #num > 0 and pos.y < 10 then
				nodecore.set_node(gro, {name = modname .. ":mushroom"})
			end
		end,
	})

nodecore.register_limited_abm({
		label = "glowshroom spreading",
		nodenames = {modname .. ":mushroom_glow"},
		-- neighbors = {"air"},
		interval = 120,
		chance = 20,
		action = function(pos)
			local gro = {x = pos.x + math_random(-1, 1), y = pos.y + math_random(-1, 1), z = pos.z + math_random(-1, 1)}
			local grodown = {x = gro.x, y = gro.y - 1, z = gro.z}
			local num = minetest.find_nodes_in_area(
				{x = pos.x + 1, y = pos.y - 1, z = pos.z + 1},
				{x = pos.x - 1, y = pos.y - 1, z = pos.z - 1},
				{"nc_tree:humus", "nc_terrain:dirt"})
			if minetest.get_node(gro).name ~= "air" then return end
			if minetest.get_node(grodown).name ~= {"nc_tree:humus", "nc_terrain:dirt"} then return end
			if #num > 0 and pos.y < 10 then
				nodecore.set_node(gro, {name = modname .. ":mushroom_glow"})
			end
		end,
	})

nodecore.register_limited_abm({
		label = "luxaeterna spreading",
		nodenames = {modname .. ":mushroom_lux"},
		-- neighbors = {"air"},
		interval = 120,
		chance = 20,
		action = function(pos)
			local gro = {x = pos.x + math_random(-1, 1), y = pos.y + math_random(-1, 1), z = pos.z + math_random(-1, 1)}
			local grodown = {x = gro.x, y = gro.y - 1, z = gro.z}
			local num = minetest.find_nodes_in_area(
				{x = pos.x + 1, y = pos.y - 1, z = pos.z + 1},
				{x = pos.x - 1, y = pos.y - 1, z = pos.z - 1},
				{"nc_tree:humus", "nc_terrain:dirt"})
			if minetest.get_node(gro).name ~= "air" then return end
			if minetest.get_node(grodown).name ~= {"nc_tree:humus", "nc_terrain:dirt"} then return end
			if #num > 0 and pos.y < 10 then
				nodecore.set_node(gro, {name = modname .. ":mushroom_lux"})
			end
		end,
	})

nodecore.register_limited_abm({
		label = "starflower spreading",
		nodenames = {modname .. ":starflower"},
		-- neighbors = {"air"},
		interval = 120,
		chance = 20,
		action = function(pos)
			local gro = {x = pos.x + math_random(-1, 1), y = pos.y + math_random(-1, 1), z = pos.z + math_random(-1, 1)}
			local grodown = {x = gro.x, y = gro.y - 1, z = gro.z}
			local num = minetest.find_nodes_in_area(
				{x = pos.x + 1, y = pos.y - 1, z = pos.z + 1},
				{x = pos.x - 1, y = pos.y - 1, z = pos.z - 1},
				{"nc_tree:humus", "nc_terrain:dirt"})
			if minetest.get_node(gro).name ~= "air" then return end
			if minetest.get_node(grodown).name ~= {"nc_tree:humus", "nc_terrain:dirt"} then return end
			if #num > 0 and pos.y > 100 then
				nodecore.set_node(gro, {name = modname .. ":starflower"})
			end
		end,
	})
