-- LUALOCALS < ---------------------------------------------------------
local minetest, string
    = minetest, string
local string_gsub
    = string.gsub
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

local function flower_alias(fromname, toname)
	minetest.register_alias(fromname, toname)
	local def = minetest.registered_nodes[toname] or {}
	if def and def.place_param2 and def.place_param2 ~= 0 then
		minetest.register_lbm({
				name = modname .. ":param2_" .. string_gsub(toname, ":", "_"),
				nodenames = {fromname},
				action = function(pos, node)
					node.param2 = def.place_param2
					minetest.set_node(pos, node)
				end
			})
	end
end

flower_alias(modname .. ":flower_red", "nc_flora:flower_1_2")
flower_alias(modname .. ":flower_yellow", "nc_flora:flower_2_3")
flower_alias(modname .. ":flower_white", "nc_flora:flower_3_4")
flower_alias(modname .. ":flower_blue", "nc_flora:flower_4_5")
flower_alias(modname .. ":flower_violet", "nc_flora:flower_5_6")
