-- LUALOCALS < ---------------------------------------------------------
local minetest
    = minetest
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

for i = 1, 5 do
	local toname = "nc_flora:sedge_" .. i
	local fromname = modname .. ":grass_" .. i
	minetest.register_alias(fromname, toname)
	local def = minetest.registered_nodes[toname] or {}
	if def and def.place_param2 and def.place_param2 ~= 0 then
		minetest.register_lbm({
				name = modname .. ":grass_param2_" .. i,
				nodenames = {fromname},
				action = function(pos, node)
					node.param2 = def.place_param2
					minetest.set_node(pos, node)
				end
			})
	end
end

local function register_extra_grass(offset, scale, length)
	minetest.register_decoration({
			label = {"nc_flora:sedge_" .. length},
			deco_type = "simple",
			place_on = {"nc_terrain:dirt_with_grass"},
			sidelen = 16,
			noise_params = {
				offset = offset,
				scale = scale,
				spread = {x = 200, y = 200, z = 200},
				seed = 329,
				octaves = 3,
				persist = 0.4
			},
			y_max = 31000,
			y_min = 1,
			decoration = {modname .. ":grass_" .. length},
			param2 = 2
		})
end
register_extra_grass(-0.03, 0.09, 5)
register_extra_grass(-0.015, 0.075, 4)
register_extra_grass(0, 0.06, 3)
register_extra_grass(0.015, 0.045, 2)
register_extra_grass(0.03, 0.03, 1)
