-- LUALOCALS < ---------------------------------------------------------
local minetest
    = minetest
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

----------------------------------------
---------------SHRUB----------------
minetest.register_decoration({
		label = {modname .. ":shrub"},
		deco_type = "simple",
		place_on = {"group:soil"},
		sidelen = 16,
		fill_ratio = 0.01,
		biomes = {"unknown", "forest", "thicket"},
		y_max = 200,
		y_min = -20,
		decoration = {modname .. ":shrub"},
	})

----------------------------------------
---------------THORNBRIAR---------------

minetest.register_decoration({
		label = {modname .. ":thornbriar"},
		deco_type = "simple",
		place_on = {"group:soil"},
		sidelen = 16,
		fill_ratio = 0.4,
		biomes = {"thicket"},
		y_max = 200,
		y_min = -20,
		height = 1,
		-- height_max = 3,
		decoration = {modname .. ":thornbriar"},
	})

----------------------------------------
------------------FERN------------------
minetest.register_decoration({
		label = {modname .. ":fern"},
		deco_type = "simple",
		place_on = {"group:soil"},
		sidelen = 16,
		fill_ratio = 0.1,
		biomes = {"forest", "old_forest", "ancient_forest"},
		y_max = 2000,
		y_min = -20,
		decoration = {modname .. ":fern"},
	})

---------------------------------------
----------------LILYPAD----------------
minetest.register_decoration({
		label = {modname .. ":lilypad"},
		deco_type = "simple",
		place_on = {"group:soil", "group:crumbly", "group:stone"},
		sidelen = 16,
		noise_params = {
			offset = -0.12,
			scale = 0.3,
			spread = {x = 200, y = 200, z = 200},
			seed = 33,
			octaves = 3,
			persist = 0.7
		},
		y_max = 0,
		y_min = 0,
		decoration = "nc_nature:lilypad",
		param2 = 0,
		param2_max = 3,
		place_offset_y = 1,
	})

----------------------------------------
---------------MUSHROOMS----------------
local function mushroom_decoration(id, ymin, ymax, offset, scale, seed, place, biome)
	minetest.register_decoration({
			label = modname .. ":" .. id,
			deco_type = "simple",
			place_on = place,
			sidelen = 16,
			noise_params = {
				offset = offset,
				scale = scale,
				spread = {x = 100, y = 100, z = 100},
				seed = seed,
				octaves = 3,
				persist = 0.2
			},
			biomes = biome,
			y_max = ymax,
			y_min = ymin,
			decoration = modname .. ":" .. id,
		})
end
--------------------ID------------------ymin----ymax----offset------scale---seed----
------------------------------------------place-----biome-----
mushroom_decoration("mushroom", 1, 80, -0.42, 0.07, 42,
	{"group:soil", "group:log"}, {"grassland", "forest", "old_forest"})
mushroom_decoration("mushroom_glow", -400, 1, 0.11, 0.2, 94,
	{"group:soil", "group:log", "group:crumbly", "group:cobble"}, {""})
mushroom_decoration("mushroom_lux", -1000, -100, 0.72, 0.1, 69,
	{"group:soil", "group:crumbly", "group:cobble"}, {""})
-----------------------------------------------------------------------------------

----------------------------------------
---------------STARFLOWER---------------
minetest.register_decoration({
		label = {modname .. ":starflower"},
		deco_type = "simple",
		place_on = {"group:soil"},
		sidelen = 16,
		fill_ratio = 0.02,
		-- noise_params = {
		-- offset = -0.7,
		-- scale = 0.7,
		-- spread = {x = 250, y = 25, z = 250},
		-- seed = 777,
		-- octaves = 1,
		-- persist = 0.7
		-- },
		y_max = 31000,
		y_min = 200,
		decoration = {modname .. ":starflower"},
	})
