-- LUALOCALS < ---------------------------------------------------------
local minetest, nodecore
    = minetest, nodecore
-- LUALOCALS > ---------------------------------------------------------

local mapperlin
minetest.after(0, function() mapperlin = minetest.get_perlin(8658, 1, 0, 1) end)

nodecore.register_dungeongen({
		label = "nature dungeons",
		func = function(pos)
			if pos.y < -10 then return end
			local rng = nodecore.seeded_rng(mapperlin:get_3d(pos))
			if pos.y < 0 and rng(-10, 0) > pos.y then return end
			if rng(1, 4) ~= 1 then
				return minetest.set_node(pos, {name = "nc_concrete:adobe"})
			end
			local below = {x = pos.x, y = pos.y - 1, z = pos.z}
			local bnode = minetest.get_node(below)
			local bdef = minetest.registered_nodes[bnode.name] or {}
			return minetest.set_node(pos, {name = "nc_stonework"
					.. (rng(1, 10) <= (bdef.walkable and 9 or 2)
						and ":bricks_adobe"
						or ":bricks_adobe_bonded")})
		end
	})
